/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import java.io.File;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.parts.PartBowstring;
import net.silentchaos512.gear.api.parts.PartGrip;
import net.silentchaos512.gear.api.parts.PartHighlight;
import net.silentchaos512.gear.api.parts.PartMain;
import net.silentchaos512.gear.api.parts.PartOrigins;
import net.silentchaos512.gear.api.parts.PartRegistry;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.item.MiscUpgrades;
import net.silentchaos512.gear.item.TipUpgrades;
import net.silentchaos512.gear.item.ToolRods;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.registry.IPhasedInitializer;
import net.silentchaos512.lib.registry.SRegistry;

public class ModMaterials
implements IPhasedInitializer {
    public static final ModMaterials INSTANCE = new ModMaterials();
    public static PartMain mainWood;
    public static PartMain mainStone;
    public static PartMain mainFlint;
    public static PartMain mainIron;
    public static PartMain mainGold;
    public static PartMain mainEmerald;
    public static PartMain mainDiamond;
    public static PartMain mainObsidian;
    public static PartMain mainNetherrack;
    public static PartMain mainTerracotta;
    public static PartBowstring bowstringString;
    public static PartBowstring bowstringSinew;
    public static PartHighlight highlight;

    public void preInit(SRegistry registry, FMLPreInitializationEvent event) {
        mainWood = PartRegistry.putPart(new PartMain(ModMaterials.getPath("main_wood"), PartOrigins.BUILTIN_CORE));
        mainStone = PartRegistry.putPart(new PartMain(ModMaterials.getPath("main_stone"), PartOrigins.BUILTIN_CORE));
        mainFlint = PartRegistry.putPart(new PartMain(ModMaterials.getPath("main_flint"), PartOrigins.BUILTIN_CORE));
        mainTerracotta = PartRegistry.putPart(new PartMain(ModMaterials.getPath("main_terracotta"), PartOrigins.BUILTIN_CORE));
        mainNetherrack = PartRegistry.putPart(new PartMain(ModMaterials.getPath("main_netherrack"), PartOrigins.BUILTIN_CORE));
        mainIron = PartRegistry.putPart(new PartMain(ModMaterials.getPath("main_iron"), PartOrigins.BUILTIN_CORE));
        mainGold = PartRegistry.putPart(new PartMain(ModMaterials.getPath("main_gold"), PartOrigins.BUILTIN_CORE));
        mainEmerald = PartRegistry.putPart(new PartMain(ModMaterials.getPath("main_emerald"), PartOrigins.BUILTIN_CORE));
        mainDiamond = PartRegistry.putPart(new PartMain(ModMaterials.getPath("main_diamond"), PartOrigins.BUILTIN_CORE));
        mainObsidian = PartRegistry.putPart(new PartMain(ModMaterials.getPath("main_obsidian"), PartOrigins.BUILTIN_CORE));
        PartRegistry.putPart(new PartMain(ModMaterials.getPath("main_netherwood"), PartOrigins.BUILTIN_CORE));
        PartRegistry.putPart(new PartMain(ModMaterials.getPath("main_crimson_iron"), PartOrigins.BUILTIN_CORE));
        PartRegistry.putPart(new PartMain(ModMaterials.getPath("main_crimson_steel"), PartOrigins.BUILTIN_CORE));
        for (ToolRods toolRods : ToolRods.values()) {
            PartRegistry.putPart(toolRods.getPart());
        }
        for (Enum enum_ : TipUpgrades.values()) {
            PartRegistry.putPart(((TipUpgrades)enum_).getPart());
        }
        for (Enum enum_ : EnumDyeColor.values()) {
            PartRegistry.putPart(new PartGrip(ModMaterials.getPath("grip_wool_" + enum_.name().toLowerCase(Locale.ROOT)), PartOrigins.BUILTIN_CORE));
        }
        PartRegistry.putPart(new PartGrip(ModMaterials.getPath("grip_leather"), PartOrigins.BUILTIN_CORE));
        bowstringString = PartRegistry.putPart(new PartBowstring(ModMaterials.getPath("bowstring_string"), PartOrigins.BUILTIN_CORE));
        bowstringSinew = PartRegistry.putPart(new PartBowstring(ModMaterials.getPath("bowstring_sinew"), PartOrigins.BUILTIN_CORE));
        PartRegistry.putPart(new PartBowstring(ModMaterials.getPath("bowstring_flax"), PartOrigins.BUILTIN_CORE));
        for (Enum enum_ : MiscUpgrades.values()) {
            PartRegistry.putPart(((MiscUpgrades)enum_).getPart());
        }
        highlight = PartRegistry.putPart(new PartHighlight(ModMaterials.getPath("highlight"), PartOrigins.BUILTIN_CORE));
        UserDefined.loadUserParts();
    }

    public void init(SRegistry registry, FMLInitializationEvent event) {
        PartRegistry.resetVisiblePartCaches();
        GearHelper.resetSubItemsCache();
    }

    private static ResourceLocation getPath(String key) {
        return new ResourceLocation("silentgear", key);
    }

    private static final class UserDefined {
        private UserDefined() {
        }

        static void loadUserParts() {
            File directory = new File(Config.INSTANCE.getDirectory(), "materials");
            File[] files = directory.listFiles();
            if (!directory.isDirectory() || files == null) {
                SilentGear.log.warn("File \"{}\" is not a directory?", new Object[]{directory});
                return;
            }
            Pattern typeRegex = Pattern.compile("^[a-z]+");
            for (File file : files) {
                SilentGear.log.info("Material file found: {}", new Object[]{file});
                String filename = file.getName().replace(".json", "");
                ResourceLocation name = ModMaterials.getPath(filename);
                if (!PartRegistry.getKeySet().contains(name.toString())) {
                    Matcher match = typeRegex.matcher(filename);
                    if (!match.find()) continue;
                    String typeName = match.group();
                    PartType type = PartType.get(typeName);
                    if (type != null) {
                        SilentGear.log.info("Trying to add part {}, typeName {}", new Object[]{name, typeName});
                        PartRegistry.putPart(type.construct(name, PartOrigins.USER_DEFINED));
                        continue;
                    }
                    SilentGear.log.warn("Unknown part typeName \"{}\" for {}", new Object[]{typeName, filename});
                    continue;
                }
                SilentGear.log.info("Part already registered. Must be an override.", new Object[0]);
            }
        }
    }
}

