/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import java.io.File;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.lib.ResourceOrigin;
import net.silentchaos512.gear.api.stats.CommonItemStats;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.traits.Trait;
import net.silentchaos512.gear.api.traits.TraitRegistry;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.trait.DurabilityTrait;
import net.silentchaos512.gear.trait.PotionEffectTrait;
import net.silentchaos512.gear.trait.StatModifierTrait;
import net.silentchaos512.gear.trait.TraitRefractive;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.registry.IPhasedInitializer;
import net.silentchaos512.lib.registry.SRegistry;

public final class ModTraits
implements IPhasedInitializer {
    public static final ModTraits INSTANCE = new ModTraits();
    public static Trait adamant;
    public static Trait ancient;
    public static Trait aquatic;
    public static Trait chilled;
    public static Trait crude;
    public static Trait holy;
    public static Trait magmatic;
    public static Trait multiBreak;
    public static Trait speedBoostLight;
    public static Trait stellar;
    public static Trait synergyBoost;
    public static final float ANCIENT_XP_BOOST = 0.25f;
    public static final float SYNERGY_BOOST_MULTI = 0.04f;
    private static final int COMMON_MAX_LEVEL = 4;

    private ModTraits() {
    }

    public void preInit(SRegistry registry, FMLPreInitializationEvent event) {
        TraitRegistry.register(new DurabilityTrait(ModTraits.path("malleable"), ResourceOrigin.BUILTIN_CORE));
        TraitRegistry.register(new DurabilityTrait(ModTraits.path("brittle"), ResourceOrigin.BUILTIN_CORE));
        multiBreak = TraitRegistry.register(new Trait(ModTraits.path("multi_break"), ResourceOrigin.BUILTIN_CORE));
        speedBoostLight = TraitRegistry.register(new Trait(ModTraits.path("speed_boost_light"), ResourceOrigin.BUILTIN_CORE));
        synergyBoost = TraitRegistry.register(new Trait(ModTraits.path("synergy_boost"), ResourceOrigin.BUILTIN_CORE));
        crude = TraitRegistry.register(new Trait(ModTraits.path("crude"), ResourceOrigin.BUILTIN_CORE));
        TraitRegistry.register(new TraitRefractive(ModTraits.path("refractive"), ResourceOrigin.BUILTIN_CORE));
        ancient = TraitRegistry.register(new Trait(ModTraits.path("ancient"), ResourceOrigin.BUILTIN_CORE));
        magmatic = TraitRegistry.register(new Trait(ModTraits.path("magmatic"), ResourceOrigin.BUILTIN_CORE));
        holy = TraitRegistry.register(new Trait(ModTraits.path("holy"), 4, TextFormatting.YELLOW, 0.0f){

            @Override
            public float onAttackEntity(@Nullable EntityPlayer player, EntityLivingBase target, int level, ItemStack gear, float baseValue) {
                if (!target.func_70662_br()) {
                    return baseValue;
                }
                return baseValue + (float)(2 * level);
            }
        });
        TraitRegistry.register(new StatModifierTrait(ModTraits.path("bulky"), ResourceOrigin.BUILTIN_CORE){

            @Override
            public float onGetStat(@Nullable EntityPlayer player, ItemStat stat, int level, ItemStack gear, float value, float damageRatio) {
                float result = super.onGetStat(player, stat, level, gear, value, damageRatio);
                if (stat == CommonItemStats.ATTACK_SPEED) {
                    return result > -3.95f ? result : -3.9f;
                }
                return result;
            }
        });
        TraitRegistry.register(new StatModifierTrait(ModTraits.path("chipping"), ResourceOrigin.BUILTIN_CORE));
        TraitRegistry.register(new StatModifierTrait(ModTraits.path("eroded"), ResourceOrigin.BUILTIN_CORE));
        TraitRegistry.register(new StatModifierTrait(ModTraits.path("jagged"), ResourceOrigin.BUILTIN_CORE));
        TraitRegistry.register(new StatModifierTrait(ModTraits.path("soft"), ResourceOrigin.BUILTIN_CORE));
        adamant = TraitRegistry.register(new PotionEffectTrait(ModTraits.path("adamant"), ResourceOrigin.BUILTIN_CORE){

            @Override
            public float onAttackEntity(@Nullable EntityPlayer player, EntityLivingBase target, int level, ItemStack gear, float baseValue) {
                double baseMaxHealth = target.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
                return baseMaxHealth > 20.0 ? baseValue + (float)(2 * level) : baseValue;
            }
        });
        aquatic = TraitRegistry.register(new PotionEffectTrait(ModTraits.path("aquatic"), ResourceOrigin.BUILTIN_CORE){

            @Override
            public float onAttackEntity(@Nullable EntityPlayer player, EntityLivingBase target, int level, ItemStack gear, float baseValue) {
                if (!target.func_70648_aU()) {
                    return baseValue;
                }
                return baseValue + (float)(2 * level);
            }
        });
        chilled = TraitRegistry.register(new Trait(ModTraits.path("chilled"), ResourceOrigin.BUILTIN_CORE){

            @Override
            public float onAttackEntity(@Nullable EntityPlayer player, EntityLivingBase target, int level, ItemStack gear, float baseValue) {
                if (!target.func_70045_F()) {
                    return baseValue;
                }
                return baseValue + (float)(2 * level);
            }
        });
        stellar = TraitRegistry.register(new PotionEffectTrait(ModTraits.path("stellar"), ResourceOrigin.BUILTIN_CORE){

            @Override
            public void tick(World world, @Nullable EntityPlayer player, int level, ItemStack gear, boolean isEquipped) {
                super.tick(world, player, level, gear, isEquipped);
                if (world.func_82737_E() % (long)(400 - 40 * level) == 0L && gear.func_77952_i() > 0) {
                    GearHelper.attemptDamage(gear, -1, (EntityLivingBase)player);
                }
            }
        });
        UserDefined.loadUserTraits();
    }

    private static ResourceLocation path(String name) {
        return new ResourceLocation("silentgear", name);
    }

    private static final class UserDefined {
        private UserDefined() {
        }

        static void loadUserTraits() {
            File directory = new File(Config.INSTANCE.getDirectory(), "traits");
            File[] files = directory.listFiles();
            if (!directory.isDirectory() || files == null) {
                SilentGear.log.warn("File \"{}\" is not a directory?", new Object[]{directory});
                return;
            }
            for (File file : files) {
                SilentGear.log.info("Trait file found: {}", new Object[]{file});
                String filename = file.getName().replace(".json", "");
                ResourceLocation name = ModTraits.path(filename);
                if (TraitRegistry.get(name.toString()) != null) continue;
                StatModifierTrait trait = new StatModifierTrait(name, ResourceOrigin.USER_DEFINED);
                TraitRegistry.register(trait);
            }
        }
    }
}

