/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.item.IStatItem;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.parts.PartMain;
import net.silentchaos512.gear.api.parts.PartRegistry;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.traits.Trait;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.client.util.TooltipFlagTC;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.init.ModMaterials;
import net.silentchaos512.gear.item.blueprint.Blueprint;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.util.I18nHelper;

public class ToolHead
extends Item
implements IStatItem {
    private static final String NBT_ROOT = "ToolHeadData";
    private static final String NBT_TOOL_CLASS = "ToolClass";
    private static final String NBT_MATERIALS = "Materials";
    private static final String NBT_STAT_CACHE = "StatCache";
    private static final String NBT_IS_EXAMPLE = "IsExample";

    public ItemStack getStack(String toolClass, PartDataList parts) {
        ItemStack result = new ItemStack((Item)this);
        NBTTagCompound tags = ToolHead.getData(result);
        tags.func_74778_a(NBT_TOOL_CLASS, toolClass);
        NBTTagList tagList = new NBTTagList();
        for (ItemPartData data : parts.getMains()) {
            NBTTagCompound tagCompound = data.writeToNBT(new NBTTagCompound());
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tags.func_74782_a(NBT_MATERIALS, (NBTBase)tagList);
        ToolHead.writeStatCache(result, parts);
        return result;
    }

    public ItemStack getStack(String toolClass, PartMain part, boolean isExample) {
        ItemPartData partData = ItemPartData.instance(part, MaterialGrade.C);
        ItemStack result = new ItemStack((Item)this);
        NBTTagCompound tags = ToolHead.getData(result);
        tags.func_74778_a(NBT_TOOL_CLASS, toolClass);
        tags.func_74757_a(NBT_IS_EXAMPLE, isExample);
        NBTTagList tagList = new NBTTagList();
        NBTTagCompound partTags = new NBTTagCompound();
        partData.writeToNBT(partTags);
        tagList.func_74742_a((NBTBase)partTags);
        boolean hasGuard = "sword".equals(toolClass);
        if (hasGuard) {
            tagList.func_74742_a((NBTBase)partTags);
        }
        tags.func_74782_a(NBT_MATERIALS, (NBTBase)tagList);
        ToolHead.writeStatCache(result, PartDataList.of(partData));
        return result;
    }

    private static void writeStatCache(ItemStack stack, PartDataList parts) {
        ICoreItem item = ModItems.toolClasses.get(ToolHead.getToolClass(stack));
        Map<Trait, Integer> traits = TraitHelper.getTraits(parts);
        double synergy = GearData.calculateSynergyValue(parts, parts.getUniqueParts(true), traits);
        Multimap<ItemStat, StatInstance> stats = GearData.getStatModifiers(item, parts, synergy);
        NBTTagCompound tags = new NBTTagCompound();
        for (ItemStat stat : stats.keySet()) {
            float value = stat.compute(0.0f, stats.get((Object)stat));
            tags.func_74776_a(stat.getName().func_110623_a(), value);
        }
        tags.func_74776_a("synergy", (float)synergy);
        ToolHead.getData(stack).func_74782_a(NBT_STAT_CACHE, (NBTBase)tags);
    }

    @Nonnull
    public static String getToolClass(ItemStack stack) {
        return ToolHead.getData(stack).func_74779_i(NBT_TOOL_CLASS);
    }

    @Nullable
    public static ItemPartData getPrimaryPart(ItemStack stack) {
        NBTTagCompound tags = ToolHead.getData(stack);
        if (!tags.func_74764_b(NBT_MATERIALS)) {
            return ItemPartData.instance(ModMaterials.mainWood);
        }
        NBTTagList tagList = tags.func_150295_c(NBT_MATERIALS, 10);
        if (tagList.func_74745_c() == 0) {
            return ItemPartData.instance(ModMaterials.mainWood);
        }
        NBTTagCompound partTags = tagList.func_150305_b(0);
        return ItemPartData.readFromNBT(partTags);
    }

    @Nullable
    public static ItemPartData getSecondaryPart(ItemStack stack) {
        NBTTagCompound tags = ToolHead.getData(stack);
        if (!tags.func_74764_b(NBT_MATERIALS)) {
            return ItemPartData.instance(ModMaterials.mainWood);
        }
        NBTTagList tagList = tags.func_150295_c(NBT_MATERIALS, 10);
        if (tagList.func_74745_c() < 2) {
            return ItemPartData.instance(ModMaterials.mainWood);
        }
        NBTTagCompound partTags = tagList.func_150305_b(1);
        return ItemPartData.readFromNBT(partTags);
    }

    @Nonnull
    public static Collection<ItemPartData> getAllParts(ItemStack stack) {
        ImmutableList.Builder builder = ImmutableList.builder();
        NBTTagCompound tags = ToolHead.getData(stack);
        if (tags.func_74764_b(NBT_MATERIALS)) {
            NBTTagList tagList = tags.func_150295_c(NBT_MATERIALS, 10);
            for (NBTBase nbt : tagList) {
                ItemPartData data = ItemPartData.readFromNBT((NBTTagCompound)nbt);
                if (data == null) continue;
                builder.add((Object)data);
            }
        }
        return builder.build();
    }

    @Nonnull
    private static NBTTagCompound getData(ItemStack stack) {
        return stack.func_190925_c(NBT_ROOT);
    }

    public String func_77653_i(ItemStack stack) {
        String toolClass = ToolHead.getToolClass(stack);
        if (!toolClass.isEmpty()) {
            return SilentGear.i18n.subText((IForgeRegistryEntry)this, toolClass, new Object[0]);
        }
        return super.func_77653_i(stack);
    }

    public static String getModelKey(ItemStack stack) {
        ICoreTool toolItem = ModItems.toolClasses.get(ToolHead.getToolClass(stack));
        String toolClass = ToolHead.getToolClass(stack);
        ItemPartData primary = ToolHead.getPrimaryPart(stack);
        ItemPartData secondary = toolItem != null && toolItem.hasSwordGuard() ? ToolHead.getSecondaryPart(stack) : null;
        return ToolHead.getModelKey(toolClass, primary, secondary);
    }

    public static String getModelKey(String toolClass, @Nullable ItemPartData primary, @Nullable ItemPartData secondary) {
        return toolClass + "_head|" + (primary != null ? primary.getModelIndex(0) : "null") + (secondary != null ? "|" + secondary.getModelIndex(0) : "");
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        ICoreItem toolItem;
        I18nHelper i18n = SilentGear.i18n;
        String toolClass = ToolHead.getToolClass(stack);
        Collection<ItemPartData> parts = ToolHead.getAllParts(stack);
        boolean hasUngradedParts = parts.stream().anyMatch(p -> p.getGrade() == MaterialGrade.NONE);
        if (hasUngradedParts) {
            list.add(TextFormatting.ITALIC + SilentGear.i18n.miscText("ungradedParts", new Object[0]));
        }
        GearClientHelper.tooltipListParts(stack, list, parts);
        if (ToolHead.getData(stack).func_74767_n(NBT_IS_EXAMPLE)) {
            list.add(TextFormatting.YELLOW + i18n.translate("misc", "exampleOutput1", new Object[0]));
            list.add(TextFormatting.YELLOW + i18n.translate("misc", "exampleOutput2", new Object[0]));
        }
        if ((toolItem = (ICoreItem)ModItems.toolClasses.get(toolClass)) != null) {
            ItemStack constructed = toolItem.construct((Item)toolItem, parts);
            GearData.recalculateStats(constructed);
            TooltipFlagTC tooltipFlag = TooltipFlagTC.withModifierKeys(flag.func_194127_a(), true, false);
            GearClientHelper.addInformation(constructed, world, list, tooltipFlag);
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return super.func_77613_e(stack);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (String toolClass : ModItems.toolClasses.keySet()) {
            for (PartMain part : PartRegistry.getVisibleMains()) {
                list.add((Object)this.getStack(toolClass, part, true));
            }
        }
    }

    public Collection<IRecipe> getExampleRecipes() {
        ArrayList<IRecipe> list = new ArrayList<IRecipe>();
        ModItems.toolClasses.forEach((toolClass, item) -> {
            Ingredient blueprint = Blueprint.getBlueprintIngredientForGear(item);
            if (blueprint != null) {
                for (PartMain part : PartRegistry.getVisibleMains()) {
                    ItemStack result = this.getStack((String)toolClass, part, true);
                    NonNullList ingredients = NonNullList.func_191196_a();
                    ingredients.add((Object)blueprint);
                    for (int i = 0; i < item.getConfig().getHeadCount(); ++i) {
                        ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{part.getCraftingStack()}));
                    }
                    list.add((IRecipe)new ShapelessRecipes("silentgear", result, ingredients));
                }
            } else {
                SilentGear.log.warn("Trying to add {} example recipes, but could not find blueprint item!", new Object[]{item.getGearClass()});
            }
        });
        return list;
    }

    @Override
    public float getStat(@Nonnull ItemStack stack, @Nonnull ItemStat stat) {
        NBTTagCompound root = ToolHead.getData(stack);
        if (!root.func_74764_b(NBT_STAT_CACHE)) {
            return stat.getDefaultValue();
        }
        NBTTagCompound tags = root.func_74775_l(NBT_STAT_CACHE);
        return tags.func_74760_g(stat.getName().func_110623_a());
    }

    public static String getSubtypeKey(ItemStack stack) {
        ItemPartData part = ToolHead.getPrimaryPart(stack);
        return ToolHead.getToolClass(stack) + (part != null ? "|" + part.getModelIndex(0) : "|empty");
    }
}

