/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.blueprint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.block.craftingstation.GuiCraftingStation;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.item.blueprint.IBlueprint;
import net.silentchaos512.lib.client.key.KeyTrackerSL;
import net.silentchaos512.lib.item.IColoredItem;
import net.silentchaos512.lib.util.I18nHelper;

public class Blueprint
extends Item
implements IBlueprint,
IColoredItem {
    private static final String NAME = "blueprint";
    private static final Map<String, Blueprint> ITEMS_BLUEPRINT = new HashMap<String, Blueprint>();
    private static final Map<String, Blueprint> ITEMS_TEMPLATE = new HashMap<String, Blueprint>();
    private static final int COLOR_OUTLINE_BLUEPRINT = 15856057;
    private static final int COLOR_OUTLINE_TEMPLATE = 12251874;
    private final boolean singleUse;
    @Nonnull
    private final ICoreItem gearItem;
    @Nonnull
    private final Function<PartDataList, ItemStack> craftingHandler;

    public Blueprint(boolean singleUse, @Nonnull ICoreItem gearItem, @Nonnull Function<PartDataList, ItemStack> craftingHandler) {
        this.singleUse = singleUse;
        if (!singleUse) {
            this.func_77642_a(this);
            ITEMS_BLUEPRINT.put(gearItem.getGearClass(), this);
        } else {
            ITEMS_TEMPLATE.put(gearItem.getGearClass(), this);
        }
        this.gearItem = gearItem;
        this.craftingHandler = craftingHandler;
    }

    @Nullable
    public static Blueprint getBlueprintForGear(ICoreItem item, boolean singleUse) {
        return singleUse ? ITEMS_TEMPLATE.get(item.getGearClass()) : ITEMS_BLUEPRINT.get(item.getGearClass());
    }

    @Nullable
    public static Ingredient getBlueprintIngredientForGear(ICoreItem item) {
        ArrayList<Blueprint> list = new ArrayList<Blueprint>();
        Blueprint blueprint = Blueprint.getBlueprintForGear(item, false);
        Blueprint template = Blueprint.getBlueprintForGear(item, true);
        if (blueprint != null) {
            list.add(blueprint);
        }
        if (template != null) {
            list.add(template);
        }
        return !list.isEmpty() ? Ingredient.func_193368_a((Item[])list.toArray(new Item[0])) : null;
    }

    @Override
    public ItemStack getCraftingResult(ItemStack blueprint, Collection<ItemStack> parts) {
        if (this.isDisabled()) {
            return ItemStack.field_190927_a;
        }
        PartDataList partList = PartDataList.from(parts);
        for (ItemPartData part : partList) {
            if (!part.getPart().isBlacklisted()) continue;
            return ItemStack.field_190927_a;
        }
        return this.craftingHandler.apply(partList);
    }

    @Override
    public int getMaterialCost(ItemStack blueprint) {
        return this.gearItem.getConfig().getHeadCount();
    }

    @Override
    public boolean isSingleUse(ItemStack blueprint) {
        return this.singleUse;
    }

    public boolean isDisabled() {
        return this.singleUse && !Config.blueprintTypes.allowTemplate() || !this.singleUse && !Config.blueprintTypes.allowBlueprint();
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        I18nHelper i18n = SilentGear.i18n;
        String itemClass = this.gearItem.getGearClass();
        String key = this.gearItem.getItem().func_77658_a() + ".name";
        list.add(TextFormatting.AQUA + i18n.translate(key, new Object[0]));
        if (this.gearItem instanceof ICoreTool) {
            list.add(TextFormatting.ITALIC + i18n.itemSubText(NAME, this.gearItem.getGearClass() + ".desc", new Object[0]));
        }
        int amount = this.gearItem.getConfig().getHeadCount();
        list.add(i18n.itemSubText(NAME, "materialAmount", new Object[]{amount}));
        if (this.isDisabled()) {
            list.add(TextFormatting.DARK_RED + i18n.itemSubText(NAME, "disabled", new Object[0]));
        } else if (this.singleUse) {
            list.add(TextFormatting.RED + i18n.itemSubText(NAME, "singleUse", new Object[0]));
        } else {
            list.add(TextFormatting.GREEN + i18n.itemSubText(NAME, "multiUse", new Object[0]));
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiCraftingStation) {
            list.add(TextFormatting.GREEN + i18n.itemSubText(NAME, "canMix", new Object[0]));
        } else {
            list.add(TextFormatting.RED + i18n.itemSubText(NAME, "noMixing", new Object[0]));
        }
        if (this.gearItem instanceof ICoreTool) {
            list.add("");
            if (KeyTrackerSL.isAltDown()) {
                String locToolName = i18n.itemSubText(itemClass, "name", new Object[0]);
                list.add(TextFormatting.YELLOW + i18n.itemSubText(NAME, "itemRecipe1", new Object[]{locToolName}));
                String toolHeadName = i18n.itemSubText("tool_head", itemClass, new Object[0]);
                list.add("  " + i18n.itemSubText(NAME, "itemRecipe2", new Object[]{1, toolHeadName}));
                for (PartType type : PartType.getValues()) {
                    int required;
                    if (type == PartType.MAIN || (required = this.gearItem.getConfig().getCraftingPartCount(type)) <= 0) continue;
                    String partName = i18n.translate("part", "type." + type.getName(), new Object[0]);
                    list.add("  " + i18n.itemSubText(NAME, "itemRecipe2", new Object[]{required, partName}));
                }
            } else {
                list.add(TextFormatting.YELLOW + i18n.itemSubText(NAME, "altForRecipe", new Object[0]));
            }
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.isDisabled()) {
            super.func_150895_a(tab, items);
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack).replaceFirst("_[a-z]+$", "");
    }

    public IItemColor getColorHandler() {
        return (stack, tintIndex) -> {
            if (tintIndex == 0) {
                return 0xFFFFFF;
            }
            return this.singleUse ? 12251874 : 15856057;
        };
    }
}

