/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreArmor;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.api.parts.PartDisplayProperties;
import net.silentchaos512.gear.api.parts.PartMain;
import net.silentchaos512.gear.api.parts.PartRegistry;
import net.silentchaos512.gear.api.stats.CommonItemStats;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.config.ConfigOptionEquipment;
import net.silentchaos512.gear.init.ModMaterials;
import net.silentchaos512.gear.item.blueprint.Blueprint;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public class CoreArmor
extends ItemArmor
implements ICoreArmor {
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("cfea1f82-ab07-40ed-8384-045446707a98"), UUID.fromString("9f441293-6f6e-461f-a3e2-3cad0c06f3a5"), UUID.fromString("4c90545f-c314-4db4-8a60-dac8b3a132a2"), UUID.fromString("f96e4ac9-ab1d-423b-8392-d820d12fc454")};
    private static final float[] ABSORPTION_RATIO_BY_SLOT = new float[]{0.175f, 0.3f, 0.4f, 0.125f};
    private static final int[] MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
    private final String itemName;

    public CoreArmor(EntityEquipmentSlot slot, String name) {
        super(ItemArmor.ArmorMaterial.DIAMOND, 0, slot);
        this.itemName = name;
    }

    @Override
    public String getGearClass() {
        return this.itemName;
    }

    @Override
    public GearType getGearType() {
        switch (this.func_185083_B_()) {
            case HEAD: {
                return GearType.HELMET;
            }
            case CHEST: {
                return GearType.CHESTPLATE;
            }
            case LEGS: {
                return GearType.LEGGINGS;
            }
            case FEET: {
                return GearType.BOOTS;
            }
        }
        return GearType.ARMOR;
    }

    public double getArmorProtection(ItemStack stack) {
        if (GearHelper.isBroken(stack)) {
            return 0.0;
        }
        return ABSORPTION_RATIO_BY_SLOT[this.field_77881_a.func_188454_b()] * GearData.getStat(stack, CommonItemStats.ARMOR);
    }

    public double getArmorToughness(ItemStack stack) {
        if (GearHelper.isBroken(stack)) {
            return 0.0;
        }
        return GearData.getStat(stack, CommonItemStats.ARMOR_TOUGHNESS) / 4.0f;
    }

    private static double getGenericArmorProtection(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof CoreArmor) {
            return ((CoreArmor)item).getArmorProtection(stack);
        }
        if (item instanceof ItemArmor) {
            return ((ItemArmor)item).field_77879_b;
        }
        return 0.0;
    }

    private static int getPlayerTotalArmorValue(EntityLivingBase player) {
        float total = 0.0f;
        for (ItemStack armor : player.func_184193_aE()) {
            total = (float)((double)total + CoreArmor.getGenericArmorProtection(armor));
        }
        return Math.round(total);
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == this.field_77881_a) {
            UUID uuid = ARMOR_MODIFIERS[slot.func_188454_b()];
            multimap.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(uuid, "Armor modifier", this.getArmorProtection(stack), 0));
            multimap.put((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier(uuid, "Armor toughness", this.getArmorToughness(stack), 0));
        }
        return multimap;
    }

    @Override
    @Nonnull
    public ConfigOptionEquipment getConfig() {
        switch (this.field_77881_a) {
            case FEET: {
                return Config.boots;
            }
            case LEGS: {
                return Config.leggings;
            }
            case CHEST: {
                return Config.chestplate;
            }
            case HEAD: {
                return Config.helmet;
            }
        }
        throw new IllegalArgumentException("Armor type is set to " + this.field_77881_a);
    }

    @Override
    public boolean matchesRecipe(@Nonnull Collection<ItemStack> parts) {
        return false;
    }

    public int getMaxDamage(ItemStack stack) {
        int maxDamageFactor = GearData.getStatInt(stack, CommonItemStats.ARMOR_DURABILITY);
        return MAX_DAMAGE_ARRAY[this.field_77881_a.func_188454_b()] * maxDamageFactor;
    }

    public void setDamage(ItemStack stack, int damage) {
        if (GearHelper.isUnbreakable(stack)) {
            return;
        }
        if (!Config.gearBreaksPermanently) {
            damage = MathHelper.func_76125_a((int)damage, (int)0, (int)this.getMaxDamage(stack));
        }
        super.setDamage(stack, damage);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return GearHelper.getIsRepairable(toRepair, repair);
    }

    public int getItemEnchantability(ItemStack stack) {
        return GearData.getStatInt(stack, CommonItemStats.ENCHANTABILITY);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        GearHelper.onUpdate(itemStack, world, (Entity)player, 0, true);
    }

    public Collection<IRecipe> getExampleRecipes() {
        ArrayList<IRecipe> list = new ArrayList<IRecipe>();
        Ingredient blueprint = Blueprint.getBlueprintIngredientForGear(this);
        if (blueprint != null) {
            for (PartMain part : PartRegistry.getVisibleMains()) {
                ItemStack result = this.construct((Item)this, new ItemStack[]{part.getCraftingStack()});
                NonNullList ingredients = NonNullList.func_191196_a();
                ingredients.add((Object)blueprint);
                for (int i = 0; i < this.getConfig().getHeadCount(); ++i) {
                    ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{part.getCraftingStack()}));
                }
                list.add((IRecipe)new ShapelessRecipes("silentgear", result, ingredients));
            }
        } else {
            SilentGear.log.warn("Trying to add {} example recipes, but could not find blueprint item!", new Object[]{this.itemName});
        }
        return list;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            GearHelper.getSubItems(this, tab, subItems);
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        int layer;
        int n = layer = slot == EntityEquipmentSlot.LEGS ? 2 : 1;
        if ("overlay".equals(type)) {
            return "silentgear:textures/models/armor/all_layer_" + layer + "_overlay.png";
        }
        ItemPartData part = GearData.getPrimaryRenderPartFast(stack);
        if (part == null) {
            part = ItemPartData.instance(ModMaterials.mainIron);
        }
        PartDisplayProperties props = part.getPart().getDisplayProperties(part, stack, 0);
        return props.getTextureDomain() + ":textures/models/armor/" + props.getTextureSuffix() + "_layer_" + layer + (type != null ? "_" + type : "") + ".png";
    }

    public boolean hasOverlay(ItemStack stack) {
        return true;
    }

    public boolean func_82816_b_(ItemStack stack) {
        return true;
    }

    public int func_82814_b(ItemStack stack) {
        ItemPartData renderPart = GearData.getPrimaryRenderPartFast(stack);
        return renderPart != null ? renderPart.getColor(stack, 0) : 0xFF00FF;
    }

    public void func_82815_c(ItemStack stack) {
    }

    public void func_82813_b(ItemStack stack, int color) {
    }

    public String func_77653_i(ItemStack stack) {
        return GearHelper.getItemStackDisplayName(stack);
    }

    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flag) {
        GearClientHelper.addInformation(stack, world, list, flag);
    }
}

