/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.config.ConfigOptionEquipment;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.item.gear.CoreAxe;
import net.silentchaos512.gear.item.gear.CoreSword;
import net.silentchaos512.gear.util.GearHelper;

public class CoreMachete
extends CoreSword {
    private static final int BREAK_RANGE = 2;
    private final Set<String> toolClasses = new HashSet<String>();

    public CoreMachete() {
        this.setHarvestLevel("axe", 0);
    }

    @Override
    @Nonnull
    public ConfigOptionEquipment getConfig() {
        return Config.machete;
    }

    @Override
    public String getGearClass() {
        return "machete";
    }

    @Override
    public GearType getGearType() {
        return GearType.MACHETE;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        if (!player.func_70093_af()) {
            return ModItems.sickle.onSickleStartBreak(itemstack, pos, player, 2);
        }
        return super.onBlockStartBreak(itemstack, pos, player);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState state) {
        return GearHelper.getHarvestLevel(stack, toolClass, state, null);
    }

    public void setHarvestLevel(String toolClass, int level) {
        super.setHarvestLevel(toolClass, level);
        GearHelper.setHarvestLevel(this, toolClass, level, this.toolClasses);
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return GearHelper.isBroken(stack) ? ImmutableSet.of() : ImmutableSet.copyOf(this.toolClasses);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        float speed = GearHelper.getDestroySpeed(stack, state, CoreAxe.EXTRA_EFFECTIVE_MATERIALS);
        if (state.func_185904_a() == Material.field_151575_d || state.func_185904_a() == Material.field_151572_C || state.func_185904_a() == Material.field_151594_q) {
            return speed * 0.4f;
        }
        return speed;
    }
}

