/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.stats.CommonItemStats;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.config.ConfigOptionEquipment;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public class CoreSickle
extends ItemTool
implements ICoreTool {
    private final Set<String> toolClasses = new HashSet<String>();
    private static final int DURABILITY_USAGE = 2;
    private static final int BREAK_RANGE = 4;
    private static final int HARVEST_RANGE = 2;
    private static final Set<Material> EFFECTIVE_MATERIALS = ImmutableSet.of((Object)Material.field_151570_A, (Object)Material.field_151584_j, (Object)Material.field_151585_k, (Object)Material.field_151582_l, (Object)Material.field_151569_G);

    public CoreSickle() {
        super(Objects.requireNonNull(GearData.FAKE_MATERIAL), (Set)ImmutableSet.of());
    }

    @Override
    @Nonnull
    public ConfigOptionEquipment getConfig() {
        return Config.sickle;
    }

    @Override
    public String getGearClass() {
        return "sickle";
    }

    @Override
    public GearType getGearType() {
        return GearType.SICKLE;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack sickle = player.func_184586_b(hand);
        if (GearHelper.isBroken(sickle)) {
            return EnumActionResult.PASS;
        }
        IBlockState state = worldIn.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof IGrowable)) {
            return EnumActionResult.PASS;
        }
        boolean flag = false;
        int radius = 2;
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)sickle);
        for (int z = pos.func_177952_p() - 2; z <= pos.func_177952_p() + 2; ++z) {
            for (int x = pos.func_177958_n() - 2; x <= pos.func_177958_n() + 2; ++x) {
                IGrowable crop;
                BlockPos target = new BlockPos(x, pos.func_177956_o(), z);
                state = worldIn.func_180495_p(target);
                Block block = state.func_177230_c();
                if (!(block instanceof IGrowable) || block instanceof BlockDoublePlant || (crop = (IGrowable)block).func_176473_a(worldIn, target, state, worldIn.field_72995_K)) continue;
                NonNullList drops = NonNullList.func_191196_a();
                block.getDrops(drops, (IBlockAccess)worldIn, target, state, fortune);
                ForgeEventFactory.fireBlockHarvesting((List)drops, (World)worldIn, (BlockPos)target, (IBlockState)state, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)player);
                boolean foundSeed = false;
                for (ItemStack drop : drops) {
                    if (!foundSeed && drop.func_77973_b() instanceof IPlantable) {
                        IPlantable seed = (IPlantable)drop.func_77973_b();
                        if (seed.getPlant((IBlockAccess)worldIn, target) != block.func_176223_P()) continue;
                        foundSeed = true;
                        continue;
                    }
                    Block.func_180635_a((World)worldIn, (BlockPos)target, (ItemStack)drop);
                }
                worldIn.func_180501_a(target, block.func_176223_P(), 2);
                flag = true;
            }
        }
        if (flag) {
            GearHelper.attemptDamage(sickle, 2, (EntityLivingBase)player);
            player.func_71020_j(0.02f);
        }
        return flag ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    public boolean onBlockStartBreak(ItemStack sickle, BlockPos pos, EntityPlayer player) {
        return this.onSickleStartBreak(sickle, pos, player, 4);
    }

    boolean onSickleStartBreak(ItemStack sickle, BlockPos pos, EntityPlayer player, int range) {
        if (GearHelper.isBroken(sickle)) {
            return false;
        }
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        if (!EFFECTIVE_MATERIALS.contains(state.func_185904_a())) {
            return false;
        }
        int blocksBroken = 1;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int xPos = x - range; xPos <= x + range; ++xPos) {
            for (int zPos = z - range; zPos <= z + range; ++zPos) {
                BlockPos target = new BlockPos(xPos, y, zPos);
                if (xPos == x && zPos == z || world.func_180495_p(target) != state || !this.breakExtraBlock(sickle, world, target, player)) continue;
                ++blocksBroken;
            }
        }
        return super.onBlockStartBreak(sickle, pos, player);
    }

    private boolean breakExtraBlock(ItemStack sickle, World world, BlockPos pos, EntityPlayer player) {
        boolean canceled;
        if (world.func_175623_d(pos) || !(player instanceof EntityPlayerMP)) {
            return false;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        IBlockState state = player.field_70170_p.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!EFFECTIVE_MATERIALS.contains(state.func_185904_a())) {
            return false;
        }
        int xpDropped = ForgeHooks.onBlockBreakEvent((World)world, (GameType)playerMP.field_71134_c.func_73081_b(), (EntityPlayerMP)playerMP, (BlockPos)pos);
        boolean bl = canceled = xpDropped == -1;
        if (canceled) {
            return false;
        }
        if (playerMP.field_71075_bZ.field_75098_d) {
            block.func_176208_a(world, pos, state, player);
            if (block.removedByPlayer(state, world, pos, (EntityPlayer)playerMP, false)) {
                block.func_176206_d(world, pos, state);
            }
            if (!world.field_72995_K) {
                playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
            }
            return true;
        }
        if (!world.field_72995_K) {
            block.func_176208_a(world, pos, state, (EntityPlayer)playerMP);
            if (block.removedByPlayer(state, world, pos, (EntityPlayer)playerMP, true)) {
                block.func_176206_d(world, pos, state);
                block.func_180657_a(world, player, pos, state, null, sickle);
                block.func_180637_b(world, pos, xpDropped);
            }
            playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        } else {
            int meta = block.func_176201_c(state);
            world.func_175718_b(2001, pos, Block.func_149682_b((Block)block) + (meta << 12));
            if (block.removedByPlayer(state, world, pos, (EntityPlayer)playerMP, true)) {
                block.func_176206_d(world, pos, state);
            }
            sickle.func_179548_a(world, state, pos, (EntityPlayer)playerMP);
        }
        return true;
    }

    @Override
    public int getDamageOnBlockBreak(ItemStack gear, World world, IBlockState state, BlockPos pos) {
        return 2;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        GearClientHelper.addInformation(stack, worldIn, tooltip, flagIn);
    }

    public boolean func_150897_b(IBlockState state) {
        return state.func_185904_a() == Material.field_151569_G;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        return GearHelper.getAttributeModifiers(slot, stack);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return GearHelper.getDestroySpeed(stack, state, EFFECTIVE_MATERIALS);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState state) {
        return GearHelper.getHarvestLevel(stack, toolClass, state, EFFECTIVE_MATERIALS);
    }

    public void setHarvestLevel(String toolClass, int level) {
        super.setHarvestLevel(toolClass, level);
        GearHelper.setHarvestLevel(this, toolClass, level, this.toolClasses);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return GearHelper.getIsRepairable(toRepair, repair);
    }

    public int getItemEnchantability(ItemStack stack) {
        return GearData.getStatInt(stack, CommonItemStats.ENCHANTABILITY);
    }

    public String func_77653_i(ItemStack stack) {
        return GearHelper.getItemStackDisplayName(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, GearHelper.calcDamageClamped(stack, damage));
        if (GearHelper.isBroken(stack)) {
            GearData.recalculateStats(stack);
        }
    }

    public int getMaxDamage(ItemStack stack) {
        return GearData.getStatInt(stack, CommonItemStats.DURABILITY);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return GearHelper.getRarity(stack);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            GearHelper.getSubItems(this, tab, subItems);
        }
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of();
    }

    public boolean func_77636_d(ItemStack stack) {
        return GearClientHelper.hasEffect(stack);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        return GearHelper.hitEntity(stack, target, attacker);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        return GearHelper.onBlockDestroyed(stack, worldIn, state, pos, entityLiving);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        GearHelper.onUpdate(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return GearClientHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }
}

