/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.trait;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.lib.ResourceOrigin;
import net.silentchaos512.gear.api.traits.Trait;
import net.silentchaos512.lib.advancements.LibTriggers;

public class DurabilityTrait
extends Trait {
    private static final ResourceLocation TRIGGER_BRITTLE = new ResourceLocation("silentgear", "brittle_proc");
    private float effectScale = 0.0f;

    public DurabilityTrait(ResourceLocation name, ResourceOrigin origin) {
        super(name, origin);
    }

    @Override
    public float onDurabilityDamage(@Nullable EntityPlayer player, int level, ItemStack gear, int damageTaken) {
        if (damageTaken != 0 && this.shouldActivate(level, gear)) {
            if (this.effectScale > 0.0f && player instanceof EntityPlayerMP) {
                LibTriggers.GENERIC_INT.trigger((EntityPlayerMP)player, TRIGGER_BRITTLE, 1);
            }
            return Math.round((float)damageTaken + this.effectScale);
        }
        return super.onDurabilityDamage(player, level, gear, damageTaken);
    }

    @Override
    protected void processExtraJson(JsonObject json) {
        this.effectScale = JsonUtils.func_151221_a((JsonObject)json, (String)"effect_scale", (float)this.effectScale);
    }
}

