/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.trait;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.lib.ResourceOrigin;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.traits.Trait;

public class StatModifierTrait
extends Trait {
    private final Map<ItemStat, StatMod> mods = new HashMap<ItemStat, StatMod>();

    public StatModifierTrait(ResourceLocation name, ResourceOrigin origin) {
        super(name, origin);
    }

    @Override
    protected void processExtraJson(JsonObject json) {
        if (!json.has("stats")) {
            SilentGear.log.error("JSON file for StatModifierTrait '{}' is missing the 'stats' array", new Object[]{this.getName()});
            return;
        }
        for (JsonElement element : json.get("stats").getAsJsonArray()) {
            JsonObject obj;
            String statName;
            ItemStat stat;
            if (!element.isJsonObject() || (stat = ItemStat.ALL_STATS.get(statName = JsonUtils.func_151219_a((JsonObject)(obj = element.getAsJsonObject()), (String)"name", (String)""))) == null) continue;
            this.mods.put(stat, StatMod.fromJson(obj));
        }
    }

    @Override
    public float onGetStat(@Nullable EntityPlayer player, ItemStat stat, int level, ItemStack gear, float value, float damageRatio) {
        StatMod mod = this.mods.get(stat);
        if (mod != null) {
            return mod.apply(level, value, damageRatio);
        }
        return value;
    }

    private static class StatMod {
        private float multi;
        private boolean factorDamage;
        private boolean factorValue;

        private StatMod() {
        }

        private float apply(int level, float value, float damageRatio) {
            float f = this.multi * (float)level;
            if (this.factorDamage) {
                f *= damageRatio;
            }
            if (this.factorValue) {
                f *= value;
            }
            return value + f;
        }

        private static StatMod fromJson(JsonObject json) {
            StatMod mod = new StatMod();
            mod.multi = JsonUtils.func_151221_a((JsonObject)json, (String)"value", (float)0.0f);
            mod.factorDamage = JsonUtils.func_151209_a((JsonObject)json, (String)"factor_damage", (boolean)true);
            mod.factorValue = JsonUtils.func_151209_a((JsonObject)json, (String)"factor_value", (boolean)true);
            return mod;
        }
    }
}

