/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.IUpgradePart;
import net.silentchaos512.gear.api.parts.ItemPart;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.parts.PartHighlight;
import net.silentchaos512.gear.api.parts.PartMain;
import net.silentchaos512.gear.api.parts.PartRod;
import net.silentchaos512.gear.api.parts.PartTip;
import net.silentchaos512.gear.api.stats.CommonItemStats;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.stats.StatModifierMap;
import net.silentchaos512.gear.api.traits.Trait;
import net.silentchaos512.gear.init.ModMaterials;
import net.silentchaos512.gear.init.ModTraits;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.util.PlayerHelper;
import net.silentchaos512.lib.util.StackHelper;

public final class GearData {
    public static final Item.ToolMaterial FAKE_MATERIAL = EnumHelper.addToolMaterial((String)"silentgems:fake_material", (int)1, (int)512, (float)5.12f, (float)5.12f, (int)32);
    private static final String NBT_ROOT = "ToolCore_Data";
    private static final String NBT_ROOT_CONSTRUCTION = "Construction";
    private static final String NBT_ROOT_PROPERTIES = "Properties";
    private static final String NBT_ROOT_MODEL_KEYS = "ModelKeys";
    private static final String NBT_ROOT_STATISTICS = "Statistics";
    private static final String NBT_CONSTRUCTION_PARTS = "Parts";
    private static final String NBT_LOCK_STATS = "LockStats";
    private static final String NBT_IS_EXAMPLE = "IsExample";
    private static final String NBT_RANDOM_GRADING_DONE = "RandomGradingDone";
    private static final String NBT_SYNERGY_DISPLAY = "synergy";
    private static final String NBT_UUID = "ToolCore_UUID";
    private static final String NBT_BROKEN_COUNT = "BrokenCount";
    private static final String NBT_REPAIR_COUNT = "RepairCount";
    private static final int MAX_MAIN_PARTS = 9;
    private static final int MAX_ROD_PARTS = 1;
    private static final int MAX_TIP_PARTS = 1;
    private static final double SYNERGY_MULTI = 1.1;

    private GearData() {
        throw new IllegalAccessError("Utility class");
    }

    public static void recalculateStats(EntityPlayer player, ItemStack stack) {
        boolean partsListValid;
        GearData.getUUID(stack);
        ICoreItem item = (ICoreItem)stack.func_77973_b();
        PartDataList parts = GearData.getConstructionParts(stack);
        NBTTagCompound propertiesCompound = GearData.getData(stack, NBT_ROOT_PROPERTIES);
        if (!propertiesCompound.func_74764_b(NBT_LOCK_STATS)) {
            propertiesCompound.func_74757_a(NBT_LOCK_STATS, false);
        }
        boolean statsUnlocked = !propertiesCompound.func_74767_n(NBT_LOCK_STATS);
        boolean bl = partsListValid = !parts.isEmpty() && !parts.getMains().isEmpty();
        if (statsUnlocked && partsListValid) {
            GearData.addOrRemoveHighlightPart(stack, parts);
            PartDataList uniqueParts = parts.getUniqueParts(true);
            Map<Trait, Integer> traits = TraitHelper.getTraits(parts);
            double synergy = GearData.calculateSynergyValue(parts, uniqueParts, traits);
            Multimap<ItemStat, StatInstance> stats = GearData.getStatModifiers(item, parts, synergy);
            float damageRatio = (float)stack.func_77952_i() / (float)stack.func_77958_k();
            for (ItemStat stat : stats.keySet()) {
                float initialValue = stat.compute(0.0f, stats.get((Object)stat));
                float value = TraitHelper.activateTraits(stack, initialValue, (trait, level, val) -> trait.onGetStat(null, stat, level, stack, val, damageRatio));
                propertiesCompound.func_74776_a(stat.getName().func_110623_a(), value);
            }
            NBTTagList traitList = new NBTTagList();
            for (Trait trait2 : traits.keySet()) {
                int level2 = traits.get(trait2);
                traitList.func_74742_a((NBTBase)trait2.writeToNBT(level2));
            }
            propertiesCompound.func_74782_a("Traits", (NBTBase)traitList);
            propertiesCompound.func_74776_a(NBT_SYNERGY_DISPLAY, (float)synergy);
        }
        GearData.createAndSaveModelKeys(stack, item, parts);
    }

    private static void addOrRemoveHighlightPart(ItemStack stack, PartDataList parts) {
        ItemPartData primary = parts.getPrimaryMain();
        if (primary == null) {
            return;
        }
        boolean changed = false;
        if (primary.getPart().getDisplayProperties(primary, stack, 0).hasHighlight()) {
            if (parts.getParts(p -> p.getPart() instanceof PartHighlight).isEmpty()) {
                parts.add(ItemPartData.instance(ModMaterials.highlight));
                changed = true;
            }
        } else {
            changed = parts.removeIf(p -> p.getPart() instanceof PartHighlight);
        }
        if (changed) {
            GearData.writeConstructionParts(stack, parts);
        }
    }

    @Deprecated
    public static void recalculateStats(ItemStack stack) {
        GearData.recalculateStats(null, stack);
    }

    private static void createAndSaveModelKeys(ItemStack stack, ICoreItem item, PartDataList parts) {
        stack.func_190925_c(NBT_ROOT).func_82580_o(NBT_ROOT_MODEL_KEYS);
        NBTTagCompound modelKeys = GearData.getData(stack, NBT_ROOT_MODEL_KEYS);
        for (int i = 0; i < item.getAnimationFrames(); ++i) {
            modelKeys.func_74778_a(Integer.toString(i), item.getModelKey(stack, i, parts.toArray(new ItemPartData[0])));
        }
    }

    public static String getCachedModelKey(ItemStack stack, int animationFrame) {
        String key;
        if (!(stack.func_77973_b() instanceof ICoreItem)) {
            return "Invalid item!";
        }
        NBTTagCompound tags = GearData.getData(stack, NBT_ROOT_MODEL_KEYS);
        if (!tags.func_74764_b(key = Integer.toString(animationFrame))) {
            tags.func_74778_a(key, ((ICoreItem)stack.func_77973_b()).getModelKey(stack, animationFrame));
        }
        return tags.func_74779_i(Integer.toString(animationFrame));
    }

    public static Multimap<ItemStat, StatInstance> getStatModifiers(@Nullable ICoreItem item, PartDataList parts, double synergy) {
        StatModifierMap stats = new StatModifierMap();
        for (ItemStat stat : ItemStat.ALL_STATS.values()) {
            if (item != null) {
                stats.put(stat, item.getConfig().getBaseModifier(stat));
                stats.put(stat, item.getConfig().getStatModifier(stat));
            }
            int partCount = 0;
            for (ItemPartData partData : parts) {
                String idSuffix = "_" + ++partCount;
                for (StatInstance inst : partData.getStatModifiers(stat)) {
                    if (inst.getOp() == StatInstance.Operation.AVG && stat.isAffectedByGrades()) {
                        float gradeBonus = 1.0f + (float)partData.getGrade().bonusPercent / 100.0f;
                        float statValue = inst.getValue() * gradeBonus;
                        stats.put(stat, new StatInstance(inst.getId() + idSuffix, statValue, StatInstance.Operation.AVG));
                        continue;
                    }
                    stats.put(stat, inst);
                }
            }
            if (!stat.doesSynergyApply()) continue;
            stats.put(stat, new StatInstance("synergy_multi", (float)synergy - 1.0f, StatInstance.Operation.MUL2));
        }
        return stats;
    }

    private static double getBaseSynergy(PartDataList parts) {
        int x = parts.getMains().size();
        double a = 1.1;
        return 1.1 * ((double)x / ((double)x + 1.1)) + 0.47619047619047616;
    }

    public static double calculateSynergyValue(PartDataList parts, PartDataList uniqueParts, Map<Trait, Integer> traits) {
        float primaryRarity;
        double synergy = GearData.getBaseSynergy(uniqueParts);
        ItemPartData primaryMain = parts.getPrimaryMain();
        float maxRarity = primaryRarity = primaryMain == null ? 0.0f : primaryMain.computeStat(CommonItemStats.RARITY);
        int maxTier = 0;
        for (ItemPartData data : uniqueParts) {
            maxRarity = Math.max(maxRarity, data.computeStat(CommonItemStats.RARITY));
            maxTier = Math.max(maxTier, data.getPart().getTier());
        }
        for (ItemPartData data : uniqueParts) {
            if (maxRarity > 0.0f) {
                float rarity = data.computeStat(CommonItemStats.RARITY);
                synergy -= 0.005 * (double)Math.abs(primaryRarity - rarity);
            }
            if (maxTier <= 0) continue;
            int tier = data.getPart().getTier();
            synergy -= (double)(0.16f * (float)Math.abs(maxTier - tier));
        }
        if (synergy > 1.0 && traits.containsKey(ModTraits.synergyBoost)) {
            int level = traits.get(ModTraits.synergyBoost);
            synergy += (double)((float)level * 0.04f);
        }
        if (traits.containsKey(ModTraits.crude)) {
            int level = traits.get(ModTraits.crude);
            synergy -= (double)((float)level * 0.04f);
        }
        return synergy;
    }

    public static float getStat(ItemStack stack, ItemStat stat) {
        String key;
        NBTTagCompound tags = GearData.getData(stack, NBT_ROOT_PROPERTIES);
        if (tags.func_74764_b(key = stat.getName().func_110623_a())) {
            return tags.func_74760_g(key);
        }
        return stat.getDefaultValue();
    }

    public static int getStatInt(ItemStack stack, ItemStat stat) {
        return Math.round(GearData.getStat(stack, stat));
    }

    public static boolean hasLockedStats(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_PROPERTIES).func_74767_n(NBT_LOCK_STATS);
    }

    public static void setLockedStats(ItemStack stack, boolean lock) {
        GearData.getData(stack, NBT_ROOT_PROPERTIES).func_74757_a(NBT_LOCK_STATS, lock);
    }

    public static PartDataList getConstructionParts(ItemStack stack) {
        NBTTagCompound tags = GearData.getData(stack, NBT_ROOT_CONSTRUCTION);
        NBTTagList tagList = tags.func_150295_c(NBT_CONSTRUCTION_PARTS, 10);
        PartDataList list = PartDataList.of(new ItemPartData[0]);
        int mainsFound = 0;
        int rodsFound = 0;
        int tipsFound = 0;
        for (NBTBase nbt : tagList) {
            NBTTagCompound partCompound;
            ItemPartData data;
            if (!(nbt instanceof NBTTagCompound) || (data = ItemPartData.readFromNBT(partCompound = (NBTTagCompound)nbt)) == null) continue;
            if (data.getPart() instanceof PartMain && ++mainsFound <= 9) {
                list.add(data);
                continue;
            }
            if (data.getPart() instanceof PartRod && ++rodsFound <= 1) {
                list.add(data);
                continue;
            }
            if (data.getPart() instanceof PartTip && ++tipsFound <= 1) {
                list.add(data);
                continue;
            }
            list.add(data);
        }
        return list;
    }

    public static float getSynergyDisplayValue(ItemStack equipment) {
        return GearData.getData(equipment, NBT_ROOT_PROPERTIES).func_74760_g(NBT_SYNERGY_DISPLAY);
    }

    @Nullable
    public static ItemPartData getPrimaryPart(ItemStack stack) {
        return GearData.getPartByIndex(stack, 0);
    }

    @Nullable
    public static ItemPartData getSecondaryPart(ItemStack stack) {
        return GearData.getPartByIndex(stack, 1);
    }

    @Nullable
    public static ItemPartData getPrimaryRenderPartFast(ItemStack stack) {
        NBTTagCompound tags = GearData.getData(stack, NBT_ROOT_CONSTRUCTION);
        NBTTagList tagList = tags.func_150295_c(NBT_CONSTRUCTION_PARTS, 10);
        NBTBase nbt = tagList.func_179238_g(0);
        if (nbt instanceof NBTTagEnd) {
            return null;
        }
        ItemPart part = ItemPart.fromNBT((NBTTagCompound)nbt);
        if (part == null) {
            return null;
        }
        return ItemPartData.instance(part);
    }

    @Nullable
    public static ItemPartData getPartByIndex(ItemStack stack, int index) {
        NBTTagCompound tags = GearData.getData(stack, NBT_ROOT_CONSTRUCTION);
        NBTTagList tagList = tags.func_150295_c(NBT_CONSTRUCTION_PARTS, 10);
        NBTBase nbt = tagList.func_179238_g(index);
        if (nbt instanceof NBTTagEnd) {
            return null;
        }
        ItemPartData data = ItemPartData.readFromNBT((NBTTagCompound)nbt);
        return data != null && data.getPart() instanceof PartMain ? data : null;
    }

    public static void addUpgradePart(ItemStack gear, ItemStack partStack) {
        ItemPartData part = ItemPartData.fromStack(partStack);
        if (part != null) {
            GearData.addUpgradePart(gear, part);
        }
    }

    public static void addUpgradePart(ItemStack gear, ItemPartData part) {
        if (!(gear.func_77973_b() instanceof ICoreItem)) {
            SilentGear.log.error("Tried to add upgrade part to non-gear item {}", new Object[]{gear});
            throw new IllegalArgumentException("Invalid Item type");
        }
        PartDataList parts = GearData.getConstructionParts(gear);
        if (part.getPart() instanceof IUpgradePart) {
            IUpgradePart upgradePart = (IUpgradePart)((Object)part.getPart());
            if (!upgradePart.isValidFor((ICoreItem)gear.func_77973_b())) {
                return;
            }
            if (upgradePart.replacesExisting()) {
                parts.removeIf(p -> p.getPart().getPartPosition() == part.getPart().getPartPosition());
            }
        }
        for (ItemPartData partInList : parts) {
            if (partInList.getPart() != part.getPart()) continue;
            return;
        }
        parts.add(part);
        GearData.writeConstructionParts(gear, parts);
    }

    public static boolean hasPart(ItemStack gear, ItemPart upgrade) {
        NBTTagCompound tags = GearData.getData(gear, NBT_ROOT_CONSTRUCTION);
        NBTTagList tagList = tags.func_150295_c(NBT_CONSTRUCTION_PARTS, 10);
        String upgradeName = upgrade.getRegistryName().toString();
        for (NBTBase nbt : tagList) {
            NBTTagCompound partCompound;
            String partKey;
            if (!(nbt instanceof NBTTagCompound) || !(partKey = (partCompound = (NBTTagCompound)nbt).func_74779_i("Key")).equals(upgradeName)) continue;
            return true;
        }
        return false;
    }

    public static void writeConstructionParts(ItemStack stack, Collection<ItemPartData> parts) {
        NBTTagCompound tags = GearData.getData(stack, NBT_ROOT_CONSTRUCTION);
        NBTTagList tagList = new NBTTagList();
        for (ItemPartData data : parts) {
            tagList.func_74742_a((NBTBase)data.writeToNBT(new NBTTagCompound()));
        }
        tags.func_74782_a(NBT_CONSTRUCTION_PARTS, (NBTBase)tagList);
    }

    public static UUID getUUID(ItemStack gear) {
        if (!(gear.func_77973_b() instanceof ICoreItem)) {
            return null;
        }
        NBTTagCompound tags = StackHelper.getTagCompound((ItemStack)gear, (boolean)true);
        if (!tags.func_186855_b(NBT_UUID)) {
            UUID uuid = UUID.randomUUID();
            tags.func_186854_a(NBT_UUID, uuid);
            return uuid;
        }
        return tags.func_186857_a(NBT_UUID);
    }

    private static NBTTagCompound getData(ItemStack stack, String compoundKey) {
        NBTTagCompound rootTag = stack.func_190925_c(NBT_ROOT);
        if (!rootTag.func_74764_b(compoundKey)) {
            rootTag.func_74782_a(compoundKey, (NBTBase)new NBTTagCompound());
        }
        return rootTag.func_74775_l(compoundKey);
    }

    static NBTTagCompound getPropertiesData(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_PROPERTIES);
    }

    static NBTTagCompound getStatisticsCompound(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_STATISTICS);
    }

    static void setExampleTag(ItemStack stack, boolean value) {
        GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74757_a(NBT_IS_EXAMPLE, value);
    }

    public static boolean isExampleGear(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74767_n(NBT_IS_EXAMPLE);
    }

    public static boolean isRandomGradingDone(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74767_n(NBT_RANDOM_GRADING_DONE);
    }

    public static void setRandomGradingDone(ItemStack stack, boolean value) {
        GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74757_a(NBT_RANDOM_GRADING_DONE, value);
    }

    public static int getBrokenCount(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74762_e(NBT_BROKEN_COUNT);
    }

    public static void incrementBrokenCount(ItemStack stack) {
        GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74768_a(NBT_BROKEN_COUNT, GearData.getBrokenCount(stack) + 1);
    }

    public static int getRepairCount(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74762_e(NBT_REPAIR_COUNT);
    }

    public static void incrementRepairCount(ItemStack stack, int amount) {
        GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74768_a(NBT_REPAIR_COUNT, GearData.getRepairCount(stack) + amount);
    }

    public static class EventHandler {
        public static final EventHandler INSTANCE = new EventHandler();

        private EventHandler() {
        }

        @SubscribeEvent
        public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            for (ItemStack stack : PlayerHelper.getNonEmptyStacks((EntityPlayer)event.player, s -> s.func_77973_b() instanceof ICoreItem)) {
                GearData.recalculateStats(stack);
            }
        }
    }
}

