/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.parts.ItemPart;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.api.parts.PartBowstring;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.parts.PartMain;
import net.silentchaos512.gear.api.parts.PartRegistry;
import net.silentchaos512.gear.api.parts.PartRod;
import net.silentchaos512.gear.api.parts.PartTip;
import net.silentchaos512.gear.init.ModMaterials;
import net.silentchaos512.gear.item.ToolRods;
import net.silentchaos512.gear.util.GearData;

public final class GearGenerator {
    private GearGenerator() {
    }

    public static List<? extends ItemPart> getPartsOfType(Class<? extends ItemPart> partClass) {
        return GearGenerator.getPartsOfType(partClass::isInstance);
    }

    public static List<? extends ItemPart> getPartsOfType(Class<? extends ItemPart> partClass, int partTier) {
        return GearGenerator.getPartsOfType((? super ItemPart part) -> partClass.isInstance(part) && (partTier < 0 || part.getTier() == partTier));
    }

    public static List<? extends ItemPart> getPartsOfType(Predicate<? super ItemPart> condition) {
        return PartRegistry.getValues().stream().filter(p -> !p.isBlacklisted()).filter(condition).collect(Collectors.toList());
    }

    public static Optional<ItemPart> selectRandom(Class<? extends ItemPart> partClass) {
        return GearGenerator.selectRandom(partClass, -1);
    }

    public static Optional<ItemPart> selectRandom(Class<? extends ItemPart> partClass, int partTier) {
        List<? extends ItemPart> list = GearGenerator.getPartsOfType(partClass, partTier);
        if (!list.isEmpty()) {
            return Optional.of(list.get(SilentGear.random.nextInt(list.size())));
        }
        ItemPart fallback = GearGenerator.getFallback(partClass);
        return fallback == null ? Optional.empty() : Optional.of(fallback);
    }

    @Nullable
    private static ItemPart getFallback(Class<? extends ItemPart> partClass) {
        SilentGear.log.debug("GearGenerator::getFallback: class {}", new Object[]{partClass});
        if (partClass == PartRod.class) {
            return ToolRods.WOOD.getPart();
        }
        if (partClass == PartBowstring.class) {
            return GearGenerator.selectRandom(partClass, -1).orElse(ModMaterials.bowstringString);
        }
        SilentGear.log.debug("    no fallback part available", new Object[0]);
        return null;
    }

    public static ItemStack create(ICoreItem item, int minTier, int maxTier) {
        if (minTier >= maxTier) {
            return GearGenerator.create(item, maxTier);
        }
        return GearGenerator.create(item, minTier + SilentGear.random.nextInt(maxTier - minTier));
    }

    public static ItemStack create(ICoreItem item, int tier) {
        Optional<ItemPart> main = GearGenerator.selectRandom(PartMain.class, tier);
        Optional<ItemPart> rod = GearGenerator.selectRandom(PartRod.class, tier);
        if (!main.isPresent() || !rod.isPresent()) {
            SilentGear.log.warn("Could not create {} of tier {}", new Object[]{item.getGearClass(), tier});
            return ItemStack.field_190927_a;
        }
        PartDataList parts = PartDataList.of(new ItemPartData[0]);
        for (int i = 0; i < item.getConfig().getHeadCount(); ++i) {
            parts.addPart(main.get());
        }
        if (item.getConfig().getRodCount() > 0) {
            parts.addPart(rod.get());
        }
        if (item.getConfig().getBowstringCount() > 0) {
            Optional<ItemPart> bowstring = GearGenerator.selectRandom(PartBowstring.class, tier);
            bowstring.ifPresent(parts::addPart);
        }
        ItemStack result = item.construct(item.getItem(), parts);
        if (item instanceof ICoreTool && SilentGear.random.nextFloat() < 0.2f * (float)tier + 0.1f) {
            Optional<ItemPart> tip = GearGenerator.selectRandom(PartTip.class);
            tip.ifPresent(part -> GearData.addUpgradePart(result, ItemPartData.instance(part)));
        }
        GearData.recalculateStats(result);
        return result;
    }
}

