/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalNotification;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.util.GearData;

public class GearStatistics {
    public static final String BLOCKS_MINED = "silentgear.blocks_mined";
    private static final LoadingCache<UUIDStack, Data> CACHE = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(5L, TimeUnit.MINUTES).removalListener(GearStatistics::onCacheRemoval).build((CacheLoader)new CacheLoader<UUIDStack, Data>(){

        public Data load(@Nonnull UUIDStack key) {
            return new Data(key);
        }
    });

    public static int getStat(ItemStack stack, String statName) {
        try {
            return ((Data)GearStatistics.CACHE.get((Object)UUIDStack.from(stack))).get(statName);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static void incrementStat(ItemStack stack, String statName) {
        GearStatistics.incrementStat(stack, statName, 1);
    }

    public static void incrementStat(ItemStack stack, String statName, int amount) {
        try {
            ((Data)GearStatistics.CACHE.get((Object)UUIDStack.from(stack))).increment(statName, amount);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private static void saveToNBT(ItemStack stack, Data data) {
        NBTTagCompound tags = GearData.getStatisticsCompound(stack);
        data.stats.forEach((arg_0, arg_1) -> ((NBTTagCompound)tags).func_74768_a(arg_0, arg_1));
        data.stats.forEach((stat, value) -> SilentGear.log.debug("    {} = {}", new Object[]{stat, value}));
    }

    private static void onCacheRemoval(RemovalNotification<UUIDStack, Data> notification) {
        GearStatistics.saveToNBT(((UUIDStack)notification.getKey()).stack, (Data)notification.getValue());
    }

    public static void getDebugText(List<String> lines) {
        lines.add("GearStatistics#CACHE size=" + CACHE.size());
    }

    private static final class UUIDStack {
        private final UUID uuid;
        private final ItemStack stack;

        private static UUIDStack from(ItemStack stack) {
            return UUIDStack.from(GearData.getUUID(stack), stack);
        }

        private static UUIDStack from(UUID uuid, ItemStack stack) {
            return new UUIDStack(uuid, stack);
        }

        private UUIDStack(UUID uuid, ItemStack stack) {
            this.uuid = uuid;
            this.stack = stack;
        }

        public int hashCode() {
            return this.uuid.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UUID)) {
                return false;
            }
            return this.uuid.equals(obj);
        }
    }

    private static final class Data {
        private final Map<String, Integer> stats = new HashMap<String, Integer>();

        private Data(UUIDStack key) {
            NBTTagCompound tags = GearData.getStatisticsCompound(key.stack);
            for (String nbtKey : tags.func_150296_c()) {
                if (!tags.func_150297_b(nbtKey, 3)) continue;
                this.stats.put(nbtKey, tags.func_74762_e(nbtKey));
            }
        }

        private boolean has(String stat) {
            return this.stats.containsKey(stat);
        }

        private int get(String stat) {
            return this.has(stat) ? this.stats.get(stat) : 0;
        }

        private void set(String stat, int value) {
            this.stats.put(stat, value);
            SilentGear.log.debug("Data.set: {} {}", new Object[]{stat, value});
        }

        private void increment(String stat, int amount) {
            this.set(stat, this.get(stat) + amount);
        }
    }
}

