/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.traits.Trait;
import net.silentchaos512.gear.api.traits.TraitFunction;
import net.silentchaos512.gear.api.traits.TraitRegistry;
import net.silentchaos512.gear.util.GearData;

public final class TraitHelper {
    private TraitHelper() {
        throw new IllegalAccessError("Utility class");
    }

    public static float activateTraits(ItemStack gear, float inputValue, TraitFunction action) {
        NBTTagList tagList = GearData.getPropertiesData(gear).func_150295_c("Traits", 10);
        float value = inputValue;
        for (NBTBase nbt : tagList) {
            NBTTagCompound tagCompound;
            String regName;
            Trait trait;
            if (!(nbt instanceof NBTTagCompound) || (trait = TraitRegistry.get(regName = (tagCompound = (NBTTagCompound)nbt).func_74779_i("Name"))) == null) continue;
            byte level = tagCompound.func_74771_c("Level");
            value = action.apply(trait, level, value);
        }
        return value;
    }

    public static int getTraitLevel(ItemStack gear, Trait trait) {
        NBTTagList tagList = GearData.getPropertiesData(gear).func_150295_c("Traits", 10);
        for (NBTBase nbt : tagList) {
            NBTTagCompound tagCompound;
            String regName;
            Trait traitOnGear;
            if (!(nbt instanceof NBTTagCompound) || (traitOnGear = TraitRegistry.get(regName = (tagCompound = (NBTTagCompound)nbt).func_74779_i("Name"))) != trait) continue;
            return tagCompound.func_74771_c("Level");
        }
        return 0;
    }

    public static Map<Trait, Integer> getTraits(PartDataList parts) {
        Trait[] keys;
        if (parts.isEmpty()) {
            return ImmutableMap.of();
        }
        LinkedHashMap<Trait, Integer> result = new LinkedHashMap<Trait, Integer>();
        HashMap countPartsWithTrait = new HashMap();
        for (ItemPartData part : parts) {
            part.getTraits().forEach((trait, level) -> {
                result.merge((Trait)trait, (Integer)level, (i1, i2) -> i1 + i2);
                countPartsWithTrait.merge(trait, 1, (i1, i2) -> i1 + i2);
            });
        }
        for (Trait trait2 : keys = result.keySet().toArray(new Trait[0])) {
            int partsWithTrait = (Integer)countPartsWithTrait.get(trait2);
            float divisor = Math.max(1, partsWithTrait);
            int value = Math.round((float)((Integer)result.get(trait2)).intValue() / divisor);
            result.put(trait2, MathHelper.func_76125_a((int)value, (int)1, (int)trait2.getMaxLevel()));
        }
        TraitHelper.cancelTraits(result, keys);
        return result;
    }

    private static void cancelTraits(Map<Trait, Integer> mapToModify, Trait[] keys) {
        block0: for (int i = 0; i < keys.length; ++i) {
            Trait t1 = keys[i];
            if (!mapToModify.containsKey(t1)) continue;
            for (int j = i + 1; j < keys.length; ++j) {
                int otherLevel;
                Trait t2 = keys[j];
                if (!mapToModify.containsKey(t2) || !t1.willCancelWith(t2)) continue;
                int level = mapToModify.get(t1);
                int cancelLevel = t1.getCanceledLevel(level, t2, otherLevel = mapToModify.get(t2).intValue());
                if (cancelLevel > 0) {
                    mapToModify.put(t1, cancelLevel);
                    mapToModify.remove(t2);
                    continue;
                }
                if (cancelLevel < 0) {
                    mapToModify.put(t2, -cancelLevel);
                    mapToModify.remove(t1);
                    continue block0;
                }
                mapToModify.remove(t1);
                mapToModify.remove(t2);
                continue block0;
            }
        }
    }

    static void tickTraits(World world, @Nullable EntityPlayer player, ItemStack gear, boolean isEquipped) {
        NBTTagList tagList = GearData.getPropertiesData(gear).func_150295_c("Traits", 10);
        for (NBTBase nbt : tagList) {
            NBTTagCompound tagCompound;
            String regName;
            Trait trait;
            if (!(nbt instanceof NBTTagCompound) || (trait = TraitRegistry.get(regName = (tagCompound = (NBTTagCompound)nbt).func_74779_i("Name"))) == null) continue;
            byte level = tagCompound.func_74771_c("Level");
            trait.tick(world, player, level, gear, isEquipped);
        }
    }
}

