/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.world;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.world.feature.NetherwoodTree;
import net.silentchaos512.lib.config.ConfigOptionOreGen;
import net.silentchaos512.lib.util.MathUtils;
import net.silentchaos512.lib.world.WorldGeneratorSL;
import org.apache.commons.lang3.ArrayUtils;

public class ModWorldGenerator
extends WorldGeneratorSL {
    private static final int NETHER_TREE_SPREAD = 6;
    public static final int NETHER_TREE_MIN_Y = 32;
    public static final int NETHER_TREE_MAX_Y = 96;

    public ModWorldGenerator() {
        super(false, "silentgear");
    }

    protected void generateSurface(World world, Random random, int posX, int posZ) {
        this.generateFlowers(world, random, posX, posZ);
    }

    protected void generateNether(World world, Random random, int posX, int posZ) {
        this.generateOres(world, random, posX, posZ, ModBlocks.crimsonIronOre, Config.crimsonIronOreGen);
        this.generateNetherTrees(world, random, posX, posZ);
    }

    private void generateFlowers(World world, Random random, int posX, int posZ) {
        if (world.field_73011_w != null && ArrayUtils.contains((int[])Config.flowerDimensionBlacklist, (int)world.field_73011_w.getDimension())) {
            return;
        }
        if (random.nextFloat() > Config.flowerClusterChance) {
            return;
        }
        int sx = posX + 8 + random.nextInt(16);
        int sy = -1;
        int sz = posZ + 8 + random.nextInt(16);
        block0: for (int i = 0; i < Config.flowerClusterSize; ++i) {
            int x = sx + random.nextInt(7) - 3;
            int y = sy < 0 ? random.nextInt(120) + 50 : sy;
            sy = y + 5;
            int z = sz + random.nextInt(9) - 4;
            BlockPos pos = new BlockPos(x, y, z);
            IBlockState state = ModBlocks.flower.func_176223_P();
            while (y > 50) {
                if (world.func_175623_d(pos) && pos.func_177956_o() < 255 && ModBlocks.flower.func_180671_f(world, pos, state)) {
                    world.func_180501_a(pos, state, 2);
                    continue block0;
                }
                pos = pos.func_177977_b();
                --y;
            }
        }
    }

    private void generateNetherTrees(World world, Random random, int posX, int posZ) {
        if (MathUtils.tryPercentage((Random)random, (double)Config.netherwoodClusterChance)) {
            int count = MathUtils.nextIntInclusive((Random)random, (int)Config.netherwoodClusterMinSize, (int)Config.netherwoodClusterMaxSize);
            int sx = posX + 8 + random.nextInt(16);
            int sz = posZ + 8 + random.nextInt(16);
            block0: for (int i = 0; i < count; ++i) {
                int x = sx + MathUtils.nextIntInclusive((Random)random, (int)-6, (int)6);
                int z = sz + MathUtils.nextIntInclusive((Random)random, (int)-6, (int)6);
                int y = MathUtils.nextIntInclusive((Random)random, (int)42, (int)96);
                BlockPos pos = new BlockPos(x, y, z);
                IBlockState state = ModBlocks.netherwoodSapling.func_176223_P();
                while (y > 32) {
                    if (world.func_175623_d(pos) && pos.func_177956_o() < 255 && ModBlocks.netherwoodSapling.func_180671_f(world, pos, state)) {
                        world.func_175656_a(pos, state);
                        new NetherwoodTree(ModBlocks.netherwoodLog.func_176223_P(), ModBlocks.netherwoodLeaves.func_176223_P()).func_180709_b(world, random, pos.func_177984_a());
                        continue block0;
                    }
                    --y;
                    pos = pos.func_177977_b();
                }
            }
        }
    }

    private void generateOres(World world, Random random, int posX, int posZ, Block block, ConfigOptionOreGen config) {
        int dimension = world.field_73011_w.getDimension();
        if (config.isEnabled() && config.canSpawnInDimension(dimension)) {
            int veinCount = config.getVeinCount(random);
            int veinSize = config.veinSize;
            for (int i = 0; i < veinCount; ++i) {
                BlockPos pos = config.getRandomPos(random, posX, posZ);
                IBlockState state = block.func_176223_P();
                new WorldGenMinable(state, veinSize, s -> s != null && s.func_177230_c() == Blocks.field_150424_aL).func_180709_b(world, random, pos);
            }
        }
    }
}

