/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.world.feature;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.lib.util.MathUtils;

public class NetherwoodTree
extends WorldGenShrub {
    private final IBlockState wood;
    private final IBlockState leaves;

    public NetherwoodTree(IBlockState wood, IBlockState leaves) {
        super(wood, leaves);
        this.wood = wood;
        this.leaves = leaves;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int startY = position.func_177956_o();
        IBlockState iblockstate = worldIn.func_180495_p(position);
        while ((iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)worldIn, position) || iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, position)) && startY > 0) {
            position = position.func_177977_b();
            iblockstate = worldIn.func_180495_p(position);
        }
        IBlockState state = worldIn.func_180495_p(position);
        if (ModBlocks.netherwoodSapling.func_180671_f(worldIn, position, state)) {
            this.func_175903_a(worldIn, position, this.wood);
            int height = MathUtils.nextIntInclusive((int)3, (int)5);
            int endY = startY + height;
            for (int y = startY; y < endY + 2; ++y) {
                BlockPos pos = position.func_177981_b(y - startY);
                if (y < endY) {
                    this.func_175903_a(worldIn, pos, this.wood);
                } else {
                    this.tryPlaceLeaves(worldIn, pos, null);
                }
                if (y == startY || y >= endY + 1) continue;
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    this.tryPlaceLeaves(worldIn, pos, facing);
                }
            }
        }
        return true;
    }

    private void tryPlaceLeaves(World worldIn, BlockPos position, @Nullable EnumFacing side) {
        BlockPos pos = side != null ? position.func_177972_a(side) : position;
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)worldIn, pos)) {
            this.func_175903_a(worldIn, pos, this.leaves);
        }
    }
}

