/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear;

import com.mojang.brigadier.CommandDispatcher;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.client.DebugOverlay;
import net.silentchaos512.gear.client.event.ExtraBlockBreakHandler;
import net.silentchaos512.gear.client.event.TooltipHandler;
import net.silentchaos512.gear.client.gui.GuiTypes;
import net.silentchaos512.gear.command.GradeTestCommand;
import net.silentchaos512.gear.command.LockStatsCommand;
import net.silentchaos512.gear.command.RecalculateStatsCommand;
import net.silentchaos512.gear.command.SGearPartsCommand;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.init.ModLootStuff;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.gear.init.ModTileEntities;
import net.silentchaos512.gear.network.Network;
import net.silentchaos512.gear.parts.PartManager;
import net.silentchaos512.gear.traits.TraitManager;
import net.silentchaos512.gear.util.IAOETool;
import net.silentchaos512.gear.world.ModWorldFeatures;
import net.silentchaos512.lib.event.InitialSpawnItems;
import net.silentchaos512.lib.inventory.ContainerType;
import net.silentchaos512.lib.inventory.TileEntityContainerType;

class SideProxy {
    SideProxy() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::imcEnqueue);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::imcProcess);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ModBlocks::registerAll);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ModItems::registerAll);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ModTileEntities::registerAll);
        MinecraftForge.EVENT_BUS.addListener(this::serverAboutToStart);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarted);
        SideProxy.registerContainersCommon();
        Config.init();
        Network.init();
        ModLootStuff.init();
        ModRecipes.init();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(ModWorldFeatures::addFeaturesToBiomes);
        IAOETool.BreakHandler.buildOreBlocksSet();
        InitialSpawnItems.add((ResourceLocation)new ResourceLocation("silentgear", "starter_blueprints"), () -> {
            if (((Boolean)Config.GENERAL.spawnWithStarterBlueprints.get()).booleanValue()) {
                return ModItems.blueprintPackage.getStack();
            }
            return ItemStack.field_190927_a;
        });
        if (SilentGear.isDevBuild()) {
            // empty if block
        }
    }

    private void imcEnqueue(InterModEnqueueEvent event) {
    }

    private void imcProcess(InterModProcessEvent event) {
    }

    private void serverAboutToStart(FMLServerAboutToStartEvent event) {
        IReloadableResourceManager resourceManager = event.getServer().func_195570_aG();
        resourceManager.func_199006_a((IResourceManagerReloadListener)TraitManager.INSTANCE);
        resourceManager.func_199006_a((IResourceManagerReloadListener)PartManager.INSTANCE);
        CommandDispatcher dispatcher = event.getServer().func_195571_aL().func_197054_a();
        LockStatsCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        RecalculateStatsCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        SGearPartsCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        if (SilentGear.isDevBuild()) {
            GradeTestCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        }
    }

    private void serverStarted(FMLServerStartedEvent event) {
        SilentGear.LOGGER.info(PartManager.MARKER, "Total gear parts loaded: {}", (Object)PartManager.getValues().size());
    }

    private static void registerContainersCommon() {
        for (GuiTypes type : GuiTypes.values()) {
            ContainerType.register(type::getContainerType, (tileType, player) -> type.getContainer((TileEntityContainerType<?>)tileType, (EntityPlayer)player));
        }
    }

    static class Server
    extends SideProxy {
        Server() {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::serverSetup);
        }

        private void serverSetup(FMLDedicatedServerSetupEvent event) {
        }
    }

    static class Client
    extends SideProxy {
        Client() {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
            MinecraftForge.EVENT_BUS.register((Object)ExtraBlockBreakHandler.INSTANCE);
            MinecraftForge.EVENT_BUS.register((Object)TooltipHandler.INSTANCE);
            MinecraftForge.EVENT_BUS.addListener(this::onPlayerLoggedIn);
            if (SilentGear.isDevBuild()) {
                MinecraftForge.EVENT_BUS.register((Object)new DebugOverlay());
            }
            Client.registerContainers();
        }

        private void clientSetup(FMLClientSetupEvent event) {
        }

        private static void registerContainers() {
            for (GuiTypes type : GuiTypes.values()) {
                ContainerType.registerGui(type::getContainerType, (tileType, player) -> type.getGui((TileEntityContainerType<?>)tileType, (EntityPlayer)player));
            }
            ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.GUIFACTORY, () -> packet -> {
                ContainerType type = (ContainerType)((Supplier)ContainerType.factories.get(packet.getId())).get();
                if (packet.getAdditionalData() != null) {
                    type.fromBytes(packet.getAdditionalData());
                }
                return (GuiScreen)((BiFunction)ContainerType.guiFactories.get(packet.getId())).apply(type, Minecraft.func_71410_x().field_71439_g);
            });
        }

        private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        }
    }
}

