/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.item;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.CommonItemStats;
import net.silentchaos512.gear.api.stats.ItemStat;

public interface ICoreRangedWeapon
extends ICoreTool {
    public static final Set<ItemStat> RELEVANT_STATS = ImmutableSet.of((Object)CommonItemStats.RANGED_DAMAGE, (Object)CommonItemStats.RANGED_SPEED, (Object)CommonItemStats.DURABILITY, (Object)CommonItemStats.ENCHANTABILITY, (Object)CommonItemStats.RARITY);

    @Override
    default public Set<ItemStat> getRelevantStats(ItemStack stack) {
        return RELEVANT_STATS;
    }

    @Override
    default public boolean requiresPartOfType(PartType type) {
        return type == PartType.MAIN || type == PartType.ROD || type == PartType.BOWSTRING;
    }

    @Override
    default public int getAnimationFrames() {
        return 4;
    }

    default public float getBaseDrawDelay(ItemStack stack) {
        return 20.0f;
    }

    default public float getDrawDelay(ItemStack stack) {
        float speed = this.getStat(stack, CommonItemStats.RANGED_SPEED);
        if (speed <= 0.0f) {
            speed = 1.0f;
        }
        return this.getBaseDrawDelay(stack) / speed;
    }
}

