/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.parts;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.silentchaos512.utils.EnumUtils;

public enum MaterialGrade {
    NONE(0),
    E(-8),
    D(-4),
    C(0),
    B(5),
    A(10),
    S(20),
    SS(30),
    SSS(40);

    private static final String NBT_KEY = "SGear_Grade";
    private static final double GRADE_STD_DEV = 1.5;
    public final int bonusPercent;

    private MaterialGrade(int bonusPercent) {
        this.bonusPercent = bonusPercent;
    }

    public static MaterialGrade fromStack(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77942_o() && stack.func_196082_o().func_74764_b(NBT_KEY)) {
            String str = stack.func_196082_o().func_74779_i(NBT_KEY);
            return MaterialGrade.fromString(str);
        }
        return NONE;
    }

    public static MaterialGrade fromString(String str) {
        if (!str.isEmpty()) {
            for (MaterialGrade grade : MaterialGrade.values()) {
                if (!grade.name().equalsIgnoreCase(str)) continue;
                return grade;
            }
        }
        return NONE;
    }

    public ItemStack applyTo(ItemStack original) {
        ItemStack result = original.func_77946_l();
        if (this == NONE) {
            return result;
        }
        this.setGradeOnStack(result);
        return result;
    }

    public static MaterialGrade selectRandom(Random random) {
        return MaterialGrade.selectRandom(random, SSS);
    }

    public static MaterialGrade selectWithCatalyst(Random random, @Nonnegative int catalystTier) {
        int ordinal = B.ordinal() + catalystTier;
        MaterialGrade median = (MaterialGrade)EnumUtils.byOrdinal((int)ordinal, (Enum)SSS);
        return MaterialGrade.selectRandom(random, median, 1.5, SSS);
    }

    public static MaterialGrade selectRandom(Random random, MaterialGrade maxGrade) {
        return MaterialGrade.selectRandom(random, B, 1.5, maxGrade);
    }

    public static MaterialGrade selectRandom(Random random, MaterialGrade median, double stdDev, MaterialGrade maxGrade) {
        int val = (int)Math.round(stdDev * random.nextGaussian() + (double)median.ordinal());
        val = MathHelper.func_76125_a((int)val, (int)1, (int)maxGrade.ordinal());
        return MaterialGrade.values()[val];
    }

    public void setGradeOnStack(@Nonnull ItemStack stack) {
        if (!stack.func_190926_b()) {
            stack.func_196082_o().func_74778_a(NBT_KEY, this.name());
        }
    }

    public ITextComponent getDisplayName() {
        TextComponentTranslation text = new TextComponentTranslation("stat.silentgear.grade." + this.name(), new Object[0]);
        return new TextComponentTranslation("part.silentgear.gradeOnPart", new Object[]{text});
    }

    public static class Argument
    implements ArgumentType<MaterialGrade> {
        public MaterialGrade parse(StringReader reader) {
            return MaterialGrade.fromString(reader.readUnquotedString());
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return ISuggestionProvider.func_197013_a(Arrays.stream(MaterialGrade.values()).map(Enum::name), (SuggestionsBuilder)builder);
        }

        public static MaterialGrade getGrade(CommandContext<CommandSource> context, String name) {
            return (MaterialGrade)((Object)context.getArgument(name, MaterialGrade.class));
        }
    }
}

