/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.parts;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.IPartSerializer;
import net.silentchaos512.gear.parts.AbstractGearPart;
import net.silentchaos512.gear.parts.type.PartBinding;
import net.silentchaos512.gear.parts.type.PartBowstring;
import net.silentchaos512.gear.parts.type.PartGrip;
import net.silentchaos512.gear.parts.type.PartHighlight;
import net.silentchaos512.gear.parts.type.PartMain;
import net.silentchaos512.gear.parts.type.PartRod;
import net.silentchaos512.gear.parts.type.PartTip;
import net.silentchaos512.gear.parts.type.PartUpgrade;

public final class PartType {
    private static final Map<ResourceLocation, PartType> VALUES = new HashMap<ResourceLocation, PartType>();
    public static final PartType BINDING = PartType.create(SilentGear.getId("binding"), "b", PartType.createSerializer("binding", PartBinding::new));
    public static final PartType BOWSTRING = PartType.create(SilentGear.getId("bowstring"), "B", PartType.createSerializer("bowstring", PartBowstring::new));
    public static final PartType GRIP = PartType.create(SilentGear.getId("grip"), "G", PartType.createSerializer("grip", PartGrip::new));
    public static final PartType HIGHLIGHT = PartType.create(SilentGear.getId("highlight"), "h", PartType.createSerializer("highlight", PartHighlight::new));
    public static final PartType MAIN = PartType.create(SilentGear.getId("main"), "M", PartType.createSerializer("main", PartMain::new));
    public static final PartType MISC_UPGRADE = PartType.create(SilentGear.getId("misc_upgrade"), "U", PartType.createSerializer("misc_upgrade", PartUpgrade::new));
    public static final PartType ROD = PartType.create(SilentGear.getId("rod"), "R", PartType.createSerializer("rod", PartRod::new));
    public static final PartType TIP = PartType.create(SilentGear.getId("tip"), "T", PartType.createSerializer("tip", PartTip::new));
    private final ResourceLocation name;
    private final String debugSymbol;
    private final IPartSerializer<? extends IGearPart> serializer;

    @Deprecated
    public static PartType create(String name, String debugSymbol, IPartSerializer<? extends IGearPart> serializer) {
        return PartType.create(new ResourceLocation(name), debugSymbol, serializer);
    }

    public static PartType create(ResourceLocation name, String debugSymbol, IPartSerializer<? extends IGearPart> serializer) {
        if (VALUES.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Already have PartType \"%s\"", name));
        }
        PartType type = new PartType(name, debugSymbol, serializer);
        VALUES.put(name, type);
        return type;
    }

    @Deprecated
    @Nullable
    public static PartType get(String name) {
        return PartType.get(new ResourceLocation(name));
    }

    @Nullable
    public static PartType get(ResourceLocation name) {
        return VALUES.get(name);
    }

    public static Collection<PartType> getValues() {
        return VALUES.values();
    }

    private PartType(ResourceLocation name, String debugSymbol, IPartSerializer<? extends IGearPart> serializer) {
        this.name = name;
        this.debugSymbol = debugSymbol;
        this.serializer = serializer;
    }

    public ITextComponent getDisplayName(int tier) {
        return new TextComponentTranslation("part." + this.name.func_110624_b() + ".type." + this.name.func_110623_a(), new Object[]{tier});
    }

    public IPartSerializer<? extends IGearPart> getSerializer() {
        return this.serializer;
    }

    public String toString() {
        return "PartType[" + this.debugSymbol + "]{name='" + this.name + "'}";
    }

    private static <T extends AbstractGearPart> IPartSerializer<T> createSerializer(String id, Function<ResourceLocation, T> function) {
        return new AbstractGearPart.Serializer<T>(new ResourceLocation("silentgear", id), function);
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public String getDebugSymbol() {
        return this.debugSymbol;
    }
}

