/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.traits;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;

public interface ITrait {
    public ResourceLocation getId();

    public int getMaxLevel();

    public boolean willCancelWith(ITrait var1);

    default public int getCanceledLevel(int level, ITrait other, int otherLevel) {
        if (this.willCancelWith(other)) {
            int diff = level - otherLevel;
            return diff < 0 ? MathHelper.func_76125_a((int)diff, (int)(-other.getMaxLevel()), (int)0) : MathHelper.func_76125_a((int)diff, (int)0, (int)this.getMaxLevel());
        }
        return level;
    }

    public ITextComponent getDisplayName(int var1);

    public ITextComponent getDescription(int var1);

    public ITraitSerializer<?> getSerializer();

    public float onAttackEntity(TraitActionContext var1, EntityLivingBase var2, float var3);

    public float onDurabilityDamage(TraitActionContext var1, int var2);

    public void onGearCrafted(TraitActionContext var1);

    public float onGetStat(TraitActionContext var1, ItemStat var2, float var3, float var4);

    public void onUpdate(TraitActionContext var1, boolean var2);
}

