/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.item.CraftingItems;

public class FlaxPlant
extends BlockCrops {
    private final boolean wild;

    public FlaxPlant(boolean wild) {
        super(Block.Properties.func_200945_a((Material)Material.field_151585_k).func_200943_b(0.0f).func_200942_a().func_200944_c().func_200947_a(SoundType.field_185850_c));
        this.wild = wild;
    }

    public IBlockState getMaturePlant() {
        return this.func_185528_e(this.func_185526_g());
    }

    protected boolean func_200014_a_(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        if (this.wild) {
            Block block = state.func_177230_c();
            return block == Blocks.field_196658_i || block == Blocks.field_150346_d || block == Blocks.field_196660_k || block == Blocks.field_196661_l;
        }
        return super.func_200014_a_(state, worldIn, pos);
    }

    protected IItemProvider func_199773_g() {
        return CraftingItems.FLAX_FIBER;
    }

    protected IItemProvider func_199772_f() {
        return ModItems.flaxseeds;
    }

    public EnumPlantType getPlantType(IBlockReader world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public void getDrops(IBlockState state, NonNullList<ItemStack> drops, World world, BlockPos pos, int fortune) {
        drops.add((Object)new ItemStack(this.func_199772_f()));
        int age = this.func_185527_x(state);
        if (age >= 7) {
            for (int i = 0; i < 1 + fortune; ++i) {
                if (SilentGear.random.nextInt(15) > age) continue;
                drops.add((Object)new ItemStack(this.func_199772_f()));
            }
            if (!this.wild) {
                int fiberCount = 2 + fortune + SilentGear.random.nextInt(3);
                for (int i = 0; i < fiberCount; ++i) {
                    drops.add((Object)new ItemStack(this.func_199773_g()));
                }
            }
        }
    }
}

