/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.analyzer;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.init.ModTileEntities;
import net.silentchaos512.gear.parts.PartManager;
import net.silentchaos512.gear.parts.type.PartMain;
import net.silentchaos512.lib.tile.SyncVariable;
import net.silentchaos512.lib.tile.TileSidedInventorySL;
import net.silentchaos512.lib.util.TimeUtils;

public class TilePartAnalyzer
extends TileSidedInventorySL
implements ITickable {
    static final int BASE_ANALYZE_TIME = TimeUtils.ticksFromSeconds((float)5.0f);
    private static final List<Tag<Item>> CATALYST_TAGS = ImmutableList.of((Object)new ItemTags.Wrapper(SilentGear.getId("analyzer_catalyst/tier1")), (Object)new ItemTags.Wrapper(SilentGear.getId("analyzer_catalyst/tier2")));
    static final int INPUT_SLOT = 0;
    static final int CATALYST_SLOT = 1;
    private static final int[] SLOTS_INPUT = new int[]{0, 1};
    private static final int[] SLOTS_OUTPUT = new int[]{2, 3, 4, 5};
    static final int INVENTORY_SIZE = SLOTS_INPUT.length + SLOTS_OUTPUT.length;
    private static final int[] SLOTS_ALL = IntStream.rangeClosed(0, INVENTORY_SIZE).toArray();
    @SyncVariable(name="progress")
    int progress = 0;
    private boolean requireClientSync = false;
    private final LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (EnumFacing[])new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN, EnumFacing.NORTH});

    public TilePartAnalyzer() {
        super(ModTileEntities.PART_ANALYZER.type(), INVENTORY_SIZE);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack input = this.getInputStack();
        IGearPart part = PartManager.from(input);
        if (part != null) {
            int outputSlot;
            if (this.progress < BASE_ANALYZE_TIME) {
                ++this.progress;
                this.requireClientSync = true;
            }
            if (this.progress >= BASE_ANALYZE_TIME && (outputSlot = this.getFreeOutputSlot()) > 0) {
                this.progress = 0;
                ItemStack stack = input.func_77946_l();
                stack.func_190920_e(1);
                input.func_190918_g(1);
                ItemStack catalyst = this.getCatalystStack();
                int catalystTier = TilePartAnalyzer.getCatalystTier(catalyst);
                if (catalystTier > 0 && !catalyst.func_190926_b()) {
                    catalyst.func_190918_g(1);
                }
                MaterialGrade.selectWithCatalyst(SilentGear.random, catalystTier).setGradeOnStack(stack);
                this.func_70299_a(outputSlot, stack);
                if (input.func_190916_E() <= 0) {
                    for (int slot : SLOTS_INPUT) {
                        if (!this.func_70301_a(slot).func_190926_b()) continue;
                        this.func_70299_a(slot, ItemStack.field_190927_a);
                    }
                }
                this.requireClientSync = true;
            }
        } else {
            this.progress = 0;
        }
        if (this.requireClientSync) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            this.requireClientSync = false;
        }
    }

    public int func_70302_i_() {
        return INVENTORY_SIZE;
    }

    public boolean func_191420_l() {
        return this.getInputStack().func_190926_b();
    }

    private ItemStack getInputStack() {
        ItemStack stack = this.func_70301_a(0);
        if (PartManager.from(stack) instanceof PartMain && MaterialGrade.fromStack(stack) == MaterialGrade.NONE) {
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack getCatalystStack() {
        return this.func_70301_a(1);
    }

    private int getFreeOutputSlot() {
        for (int slot : SLOTS_OUTPUT) {
            if (!this.func_70301_a(slot).func_190926_b()) continue;
            return slot;
        }
        return -1;
    }

    static boolean isUngradedMainPart(ItemStack stack) {
        MaterialGrade grade = MaterialGrade.fromStack(stack);
        if (grade != MaterialGrade.NONE) {
            return false;
        }
        return PartManager.from(stack) instanceof PartMain;
    }

    static int getCatalystTier(ItemStack stack) {
        Item item = stack.func_77973_b();
        for (int i = 0; i < CATALYST_TAGS.size(); ++i) {
            if (!item.func_206844_a(CATALYST_TAGS.get(i))) continue;
            return i + 1;
        }
        return 0;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tags = new NBTTagCompound();
        SyncVariable.Helper.writeSyncVars((Object)((Object)this), (NBTTagCompound)tags, (SyncVariable.Type)SyncVariable.Type.PACKET);
        ItemStack input = this.getInputStack();
        if (!input.func_190926_b()) {
            NBTTagCompound itemTags = input.serializeNBT();
            tags.func_74782_a("input_item", (INBTBase)itemTags);
        }
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, tags);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tags = super.func_189517_E_();
        SyncVariable.Helper.writeSyncVars((Object)((Object)this), (NBTTagCompound)tags, (SyncVariable.Type)SyncVariable.Type.PACKET);
        NBTTagList tagList = new NBTTagList();
        ItemStack input = this.getInputStack();
        if (!input.func_190926_b()) {
            NBTTagCompound itemTags = input.serializeNBT();
            itemTags.func_74774_a("Slot", (byte)0);
            tagList.add((INBTBase)itemTags);
        }
        tags.func_74782_a("Items", (INBTBase)tagList);
        return tags;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        NBTTagCompound tags = packet.func_148857_g();
        SyncVariable.Helper.readSyncVars((Object)((Object)this), (NBTTagCompound)tags);
        if (tags.func_74764_b("input_item")) {
            this.func_70299_a(0, ItemStack.func_199557_a((NBTTagCompound)tags.func_74775_l("input_item")));
        } else {
            this.func_70299_a(0, ItemStack.field_190927_a);
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        switch (side) {
            case UP: {
                return (int[])SLOTS_INPUT.clone();
            }
            case DOWN: {
                return (int[])SLOTS_OUTPUT.clone();
            }
        }
        return (int[])SLOTS_ALL.clone();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index != 0 && index != 1) {
            return false;
        }
        ItemStack stackInSlot = this.func_70301_a(index);
        if (stack.func_190926_b() || !stackInSlot.func_190926_b() && !stackInSlot.func_77969_a(stack)) {
            return false;
        }
        if (index == 0) {
            return TilePartAnalyzer.isUngradedMainPart(stack);
        }
        return TilePartAnalyzer.getCatalystTier(stack) > 0;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index != 0;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable EnumFacing side) {
        if (!this.field_145846_f && side != null && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == EnumFacing.UP) {
                return this.handlers[0].cast();
            }
            if (side == EnumFacing.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(cap, side);
    }

    public ITextComponent func_200200_C_() {
        return new TextComponentTranslation("block.silentgear.part_analyzer", new Object[0]);
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return null;
    }
}

