/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.craftingstation;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.silentchaos512.gear.block.craftingstation.TileCraftingStation;
import net.silentchaos512.gear.client.gui.GuiTypes;

public class BlockCraftingStation
extends BlockContainer {
    private static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockCraftingStation() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(3.0f, 10.0f).func_200947_a(SoundType.field_185848_a));
        this.func_180632_j((IBlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH));
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileCraftingStation();
    }

    public void func_196243_a(IBlockState state, World worldIn, BlockPos pos, IBlockState newState, boolean isMoving) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileCraftingStation) {
            TileCraftingStation tileCraftingStation = (TileCraftingStation)tileEntity;
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)tileCraftingStation.getInternalStorage());
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return !player.func_70093_af() && (world.field_72995_K || BlockCraftingStation.openGui(player, world, pos));
    }

    private static boolean openGui(EntityPlayer player, World world, BlockPos pos) {
        GuiTypes.CRAFTING_STATION.display(player, pos);
        return true;
    }

    @Nullable
    public IBlockState func_196258_a(BlockItemUseContext context) {
        return (IBlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        EnumFacing side = placer.func_174811_aO().func_176734_d();
        world.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)FACING, (Comparable)side), 2);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IWorldReader world, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN || face == EnumFacing.UP;
    }
}

