/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.craftingstation;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.VanillaRecipeTypes;
import net.silentchaos512.gear.block.craftingstation.TileCraftingStation;
import net.silentchaos512.gear.inventory.InventoryCraftingStation;

public class ContainerCraftingStation
extends Container {
    InventoryCrafting craftMatrix;
    InventoryCraftResult craftResult;
    private Slot outputSlot;
    private final EntityPlayer player;
    private final TileCraftingStation tile;
    private final World world;

    public ContainerCraftingStation(EntityPlayer player, TileCraftingStation tile) {
        this(player.field_71071_by, player.field_70170_p, tile);
    }

    public ContainerCraftingStation(InventoryPlayer playerInventory, World worldIn, TileCraftingStation tile) {
        this.player = playerInventory.field_70458_d;
        this.tile = tile;
        this.world = this.tile.func_145831_w();
        this.craftMatrix = new InventoryCraftingStation(this, tile, 3, 3);
        this.craftResult = new InventoryCraftResult();
        this.setupInventorySlots(playerInventory, (IInventory)this.tile);
    }

    private void setupInventorySlots(InventoryPlayer playerInv, IInventory extendedInv) {
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        this.setupCraftingGrid();
        this.setupSideInventory();
        this.setupPlayerSlots(playerInv);
        this.outputSlot = this.func_75146_a((Slot)new SlotCrafting(playerInv.field_70458_d, this.craftMatrix, (IInventory)this.craftResult, this.tile.func_70302_i_(), 124, 35));
        this.func_75130_a((IInventory)this.tile);
    }

    private void setupCraftingGrid() {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = x + y * 3;
                this.func_75146_a(new Slot((IInventory)this.craftMatrix, index, 30 + x * 18, 17 + y * 18));
            }
        }
    }

    private void setupPlayerSlots(InventoryPlayer playerInventory) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int index = x + (y + 1) * 9;
                this.func_75146_a(new Slot((IInventory)playerInventory, index, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)playerInventory, x, 8 + x * 18, 142));
        }
    }

    private void setupSideInventory() {
        int rowCount = (int)Math.ceil(6.0);
        int totalHeight = 44 + 18 * (rowCount - 2);
        for (int y = 0; y < rowCount; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = 9 + x + y * 3;
                int xPos = x * 18 - 56;
                int yPos = y * 18 + 5 + (166 - totalHeight) / 2;
                this.func_75146_a(new Slot((IInventory)this.tile, index, xPos, yPos));
            }
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return this.tile.func_70300_a(playerIn);
    }

    public Slot func_75139_a(int slotId) {
        return slotId == this.outputSlot.getSlotIndex() ? this.outputSlot : super.func_75139_a(slotId);
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.craftMatrix.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            this.tile.func_70299_a(i + 0, stack);
        }
        this.tile.func_70296_d();
    }

    public void func_75130_a(IInventory inventoryIn) {
        if (this.craftMatrix != null && this.craftResult != null) {
            this.func_192389_a(this.world, this.player, (IInventory)this.craftMatrix, this.craftResult);
            super.func_75130_a(inventoryIn);
        }
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            int playerStart = this.tile.func_70302_i_();
            int hotbarStart = playerStart + 27;
            if (slot == this.outputSlot) {
                itemstack1.func_77973_b().func_77622_d(itemstack1, this.world, playerIn);
                if (!this.func_75135_a(itemstack1, playerStart, playerStart + 36, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index >= playerStart && index < hotbarStart ? !this.func_75135_a(itemstack1, 9, 27, false) && !this.func_75135_a(itemstack1, hotbarStart, hotbarStart + 9, false) : (index >= hotbarStart && index < hotbarStart + 9 ? !this.func_75135_a(itemstack1, 9, 27, false) && !this.func_75135_a(itemstack1, playerStart, playerStart + 27, false) : !this.func_75135_a(itemstack1, playerStart, playerStart + 36, false))) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack itemstack2 = slot.func_190901_a(playerIn, itemstack1);
            if (index == 0) {
                playerIn.func_71019_a(itemstack2, false);
            }
        }
        return itemstack;
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return slotIn.field_75224_c != this.craftResult && super.func_94530_a(stack, slotIn);
    }

    protected void func_192389_a(World worldIn, EntityPlayer playerIn, IInventory craftMatrixIn, InventoryCraftResult craftResultIn) {
        if (this.world.field_72995_K) {
            return;
        }
        EntityPlayerMP entityplayermp = (EntityPlayerMP)this.player;
        ItemStack itemstack = ItemStack.field_190927_a;
        IRecipe irecipe = worldIn.func_73046_m().func_199529_aN().getRecipe(craftMatrixIn, worldIn, VanillaRecipeTypes.CRAFTING);
        if (irecipe != null && (irecipe.func_192399_d() || !this.world.func_82736_K().func_82766_b("doLimitedCrafting") || entityplayermp.func_192037_E().func_193830_f(irecipe))) {
            this.craftResult.func_193056_a(irecipe);
            itemstack = irecipe.func_77572_b((IInventory)this.craftMatrix);
        }
        int index = this.outputSlot.getSlotIndex();
        this.craftResult.func_70299_a(index, itemstack);
        entityplayermp.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(this.field_75152_c, index, itemstack));
    }
}

