/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.util.GearData;

@Mod.EventBusSubscriber(modid="silentgear", value={Dist.CLIENT})
public final class ColorHandlers {
    public static Map<String, Integer[]> gearColorCache = new HashMap<String, Integer[]>();

    private ColorHandlers() {
    }

    @SubscribeEvent
    public static void onItemColors(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        if (itemColors == null) {
            SilentGear.LOGGER.error("ItemColors is null?", (Throwable)new IllegalStateException("wat?"));
            return;
        }
        itemColors.func_199877_a(ColorHandlers::getColorTemp, (IItemProvider[])ModItems.toolClasses.values().stream().map(ICoreItem::func_199767_j).toArray(Item[]::new));
        itemColors.func_199877_a(ColorHandlers::getArmorColorTemp, (IItemProvider[])ModItems.armorClasses.values().stream().map(ICoreItem::func_199767_j).toArray(Item[]::new));
    }

    private static int getGearLayerColor(ItemStack stack, int tintIndex) {
        if (!(stack.func_77973_b() instanceof ICoreItem) || tintIndex < 0) {
            return 0xFFFFFF;
        }
        String modelKey = GearData.getCachedModelKey(stack, 0);
        Integer[] colors = gearColorCache.get(modelKey);
        return colors != null && tintIndex < colors.length ? colors[tintIndex] : 0xFFFFFF;
    }

    private static int getColorTemp(ItemStack stack, int tintIndex) {
        if (tintIndex == 0) {
            PartData part = GearData.getPartOfType(stack, PartType.ROD);
            if (part == null) {
                return 0xFFFFFF;
            }
            return part.getFallbackColor(stack, 0);
        }
        if (tintIndex == 1) {
            PartData part = GearData.getPrimaryRenderPartFast(stack);
            if (part == null) {
                return 0xFFFFFF;
            }
            return part.getFallbackColor(stack, 0);
        }
        if (tintIndex == 2) {
            PartData part = GearData.getPartOfType(stack, PartType.TIP);
            if (part == null) {
                return 0xFFFFFF;
            }
            return part.getFallbackColor(stack, 0);
        }
        if (tintIndex == 3 && stack.func_77973_b() == ModItems.sword) {
            PartData part = GearData.getPrimaryRenderPartFast(stack);
            if (part == null) {
                return 0xFFFFFF;
            }
            return part.getFallbackColor(stack, 0);
        }
        return 0xFFFFFF;
    }

    private static int getArmorColorTemp(ItemStack stack, int tintIndex) {
        if (tintIndex == 0) {
            PartData part = GearData.getPrimaryRenderPartFast(stack);
            if (part == null) {
                return 0xFFFFFF;
            }
            return part.getFallbackColor(stack, 0);
        }
        return 0xFFFFFF;
    }
}

