/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ToolType;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.event.GearEvents;
import net.silentchaos512.gear.traits.TraitConst;
import net.silentchaos512.gear.traits.TraitManager;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.client.gui.DebugRenderOverlay;

public class DebugOverlay
extends DebugRenderOverlay {
    private static final int SPLIT_WIDTH = 160;
    private static final float TEXT_SCALE = 0.7f;

    @Nonnull
    public List<String> getDebugText() {
        Entity renderViewEntity;
        ArrayList<String> list = new ArrayList<String>();
        Minecraft mc = Minecraft.func_71410_x();
        RayTraceResult rt = mc.field_71476_x;
        if (rt != null && rt.field_72313_a == RayTraceResult.Type.BLOCK && (renderViewEntity = mc.func_175606_aa()) != null) {
            BlockPos pos = rt.func_178782_a();
            IBlockState state = renderViewEntity.field_70170_p.func_180495_p(pos);
            EntityPlayerSP player = mc.field_71439_g;
            ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
            if (heldItem.func_77973_b() instanceof ICoreTool) {
                ToolType toolClass = state.func_177230_c().getHarvestTool(state);
                int blockLevel = state.func_177230_c().getHarvestLevel(state);
                int toolLevel = heldItem.func_77973_b().getHarvestLevel(heldItem, toolClass, (EntityPlayer)player, state);
                boolean canHarvest = toolLevel >= blockLevel;
                TextFormatting format = canHarvest ? TextFormatting.GREEN : TextFormatting.RED;
                String name = toolClass == null ? "null" : toolClass.getName();
                list.add(format + String.format("%s=%d (%d)", name, blockLevel, toolLevel));
                float destroySpeed = heldItem.func_150997_a(state);
                if (canHarvest) {
                    ITrait lustrous = TraitManager.get(TraitConst.LUSTROUS);
                    int level = TraitHelper.getTraitLevel(heldItem, lustrous);
                    int light = GearEvents.getLightForLustrousTrait(player.field_70170_p, player.func_180425_c());
                    float newSpeed = destroySpeed + (float)GearEvents.getLustrousSpeedBonus(level, light);
                    list.add(String.format("speed = %.1f", Float.valueOf(newSpeed)));
                } else {
                    list.add(String.format("speed = %.1f", Float.valueOf(destroySpeed)));
                }
            }
        }
        return list;
    }

    public float getTextScale() {
        return 0.7f;
    }

    public int getSplitWidth() {
        return 160;
    }

    public boolean isHidden() {
        return !SilentGear.isDevBuild();
    }
}

