/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.event;

import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.IPartMaterial;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.api.stats.CommonItemStats;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartManager;
import net.silentchaos512.gear.parts.type.PartMain;

public final class TooltipHandler {
    public static final TooltipHandler INSTANCE = new TooltipHandler();
    private static final boolean TRAIT_DISPLAY_CYCLE = false;
    private static final boolean DETAILED_MATERIAL_INFO = false;
    private static final Pattern REGEX_TRIM_TO_INT = Pattern.compile("\\.0+$");
    private static final Pattern REGEX_REMOVE_TRAILING_ZEROS = Pattern.compile("0+$");

    private TooltipHandler() {
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        IGearPart part;
        ItemStack stack = event.getItemStack();
        IGearPart iGearPart = part = !stack.func_190926_b() ? PartManager.from(stack) : null;
        if (part != null) {
            TooltipHandler.onPartTooltip(event, stack, PartData.of(part));
            return;
        }
    }

    private static void onPartTooltip(ItemTooltipEvent event, ItemStack stack, PartData partData) {
        IGearPart part = partData.getPart();
        event.getToolTip().add(part.getType().getDisplayName(part.getTier()).func_211708_a(TextFormatting.GREEN));
        if (event.getFlags().func_194127_a()) {
            // empty if block
        }
        Map<ITrait, Integer> traits = partData.getTraits();
        int numTraits = traits.size();
        int traitIndex = TooltipHandler.getTraitDisplayIndex(numTraits);
        int i = 0;
        for (ITrait trait : traits.keySet()) {
            if (traitIndex < 0 || traitIndex == i) {
                int level = traits.get(trait);
                event.getToolTip().add(trait.getDisplayName(level));
            }
            ++i;
        }
        MaterialGrade grade = MaterialGrade.fromStack(stack);
        if (KeyTracker.isControlDown()) {
            if (part instanceof PartMain) {
                TooltipHandler.getGradeLine(event, grade);
            }
            event.getToolTip().add(new TextComponentTranslation("misc.silentgear.tooltip.stats", new Object[0]).func_211708_a(TextFormatting.GOLD).func_150257_a(new TextComponentString(" (Silent Gear)").func_211708_a(TextFormatting.RESET).func_211708_a(TextFormatting.ITALIC)));
            TooltipHandler.getPartStatLines(event, stack, part);
        } else {
            if (grade != MaterialGrade.NONE && part instanceof PartMain) {
                TooltipHandler.getGradeLine(event, grade);
            }
            event.getToolTip().add(new TextComponentTranslation("misc.silentgear.tooltip.ctrlForStats", new Object[0]).func_211708_a(TextFormatting.GOLD));
        }
    }

    private static void addDetailedMaterialInfo(ItemTooltipEvent event, IGearPart part) {
        IPartMaterial mat = part.getMaterials();
        if (mat.getItem() != null) {
            event.getToolTip().add(new TextComponentString("item: " + mat.getItem().func_199767_j().getRegistryName()));
        }
        if (mat.getTag() != null) {
            event.getToolTip().add(new TextComponentString("tag: " + mat.getTag().func_199886_b()));
        }
        if (mat.getSmallItem() != null) {
            event.getToolTip().add(new TextComponentString("itemSmall: " + mat.getSmallItem().func_199767_j().getRegistryName()));
        }
        if (mat.getSmallTag() != null) {
            event.getToolTip().add(new TextComponentString("tagSmall: " + mat.getSmallTag().func_199886_b()));
        }
    }

    private static int getTraitDisplayIndex(int numTraits) {
        return -1;
    }

    private static void getGradeLine(ItemTooltipEvent event, MaterialGrade grade) {
        event.getToolTip().add(grade.getDisplayName().func_211708_a(TextFormatting.AQUA));
    }

    private static void getPartStatLines(ItemTooltipEvent event, ItemStack stack, IGearPart part) {
        PartData partData = PartData.of(part, MaterialGrade.fromStack(stack), stack);
        for (ItemStat stat : ItemStat.ALL_STATS.values()) {
            StatInstance inst;
            Collection<StatInstance> modifiers = part.getStatModifiers(stat, partData);
            if (modifiers.isEmpty() || !(inst = stat.computeForDisplay(0.0f, partData.getGrade(), modifiers)).shouldList(part, stat, event.getFlags().func_194127_a())) continue;
            boolean isZero = inst.getValue() == 0.0f;
            TextFormatting nameColor = isZero ? TextFormatting.DARK_GRAY : stat.displayColor;
            TextFormatting statColor = isZero ? TextFormatting.DARK_GRAY : TextFormatting.WHITE;
            ITextComponent nameStr = stat.getDisplayName().func_211708_a(nameColor);
            int decimalPlaces = stat.displayAsInt && inst.getOp() != StatInstance.Operation.MUL1 && inst.getOp() != StatInstance.Operation.MUL2 ? 0 : 2;
            String statStr = statColor + REGEX_TRIM_TO_INT.matcher(inst.formattedString(decimalPlaces, false)).replaceFirst("");
            if (statStr.contains(".")) {
                statStr = REGEX_REMOVE_TRAILING_ZEROS.matcher(statStr).replaceFirst("");
            }
            if (modifiers.size() > 1) {
                statStr = statStr + "*";
            }
            if (stat == CommonItemStats.ARMOR_DURABILITY) {
                statStr = statStr + "x";
            }
            event.getToolTip().add(new TextComponentString("- ").func_150257_a((ITextComponent)new TextComponentTranslation("stat.silentgear.displayFormat", new Object[]{nameStr, statStr})));
        }
    }
}

