/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.api.stats.CommonItemStats;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartManager;
import net.silentchaos512.lib.client.gui.button.GuiDropDownElement;
import net.silentchaos512.lib.client.gui.button.GuiDropDownList;
import net.silentchaos512.lib.util.TextRenderUtils;

public class GuiItemParts
extends GuiScreen {
    private static final int BUTTON_SPACING = 20;
    private static final int BUTTON_ROW_LENGTH = 12;
    private static final int BUTTON_INITIAL_OFFSET = 5;
    private static final ResourceLocation TEX_WHITE = new ResourceLocation("silentgear", "textures/gui/white.png");
    private int lastButtonId = 6900;
    private List<IGearPart> partList = new ArrayList<IGearPart>();
    private List<PartButton> partButtons = new ArrayList<PartButton>();
    private IGearPart selectedPart = null;
    private List<Tuple<String, String>> selectedPartInfo = null;

    public void func_73866_w_() {
        super.func_73866_w_();
        GuiDropDownList dropDownList = new GuiDropDownList(this.lastButtonId++, this.field_146297_k.field_195558_d.func_198105_m() - 120, 5, "Sort Order", GuiDropDownList.ExpandDirection.DOWN);
        dropDownList.addElement(new GuiDropDownElement(this.lastButtonId++, "Name", b -> this.sortParts(false, Comparator.comparing(part -> part.getDisplayName(null, ItemStack.field_190927_a).func_150254_d()))){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiItemParts.this.selectedPart = null;
                if (GuiItemParts.this.selectedPartInfo != null) {
                    GuiItemParts.this.selectedPartInfo.clear();
                }
            }
        }, (Collection)this.field_146292_n);
        dropDownList.addElement(new GuiDropDownElement(this.lastButtonId++, "Type", b -> this.sortParts(false, Comparator.comparing(part -> part.getType().getName()))){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiItemParts.this.selectedPart = null;
                if (GuiItemParts.this.selectedPartInfo != null) {
                    GuiItemParts.this.selectedPartInfo.clear();
                }
            }
        }, (Collection)this.field_146292_n);
        ItemStat.ALL_STATS.values().stream().filter(stat -> !stat.isHidden()).forEachOrdered(stat -> dropDownList.addElement(new GuiDropDownElement(this.lastButtonId++, stat.translatedName(), b -> this.sortParts(true, Comparator.comparingDouble(part -> part.computeStatValue((ItemStat)stat)))), (Collection)this.field_146292_n));
        this.field_146292_n.add(dropDownList);
        int i = 0;
        for (IGearPart part : PartManager.getValues()) {
            if (!part.isCraftingAllowed(null)) continue;
            this.partList.add(part);
            int x = i % 12;
            int y = i / 12;
            PartButton button = new PartButton(part, this.lastButtonId++, x * 20 + 5, y * 20 + 5){

                public void func_194829_a(double mouseX, double mouseY) {
                    GuiItemParts.this.selectedPart = this.part;
                    GuiItemParts.this.selectedPartInfo = GuiItemParts.getPartInfo(GuiItemParts.this.selectedPart);
                }
            };
            this.partButtons.add(button);
            this.func_189646_b(button);
            ++i;
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private void layoutPartButtons() {
        int i = 0;
        for (PartButton button : this.partButtons) {
            button.field_146128_h = i % 12 * 20 + 5;
            button.field_146129_i = i / 12 * 20 + 5;
            ++i;
        }
    }

    private void sortParts(boolean reversed, Comparator<IGearPart> comparator) {
        this.partList.sort(comparator);
        ArrayList<PartButton> sortedList = new ArrayList<PartButton>();
        block0: for (IGearPart part : this.partList) {
            for (PartButton button : this.partButtons) {
                if (button.part != part) continue;
                sortedList.add(button);
                continue block0;
            }
        }
        this.partButtons = sortedList;
        if (reversed) {
            this.partList = Lists.reverse(this.partList);
            this.partButtons = Lists.reverse(this.partButtons);
        }
        this.layoutPartButtons();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.drawSelectedPartInfo();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof PartButton)) continue;
            ((PartButton)button).drawHover(this.field_146297_k, mouseX, mouseY);
        }
    }

    private void drawSelectedPartInfo() {
        if (this.selectedPart != null && !this.selectedPartInfo.isEmpty()) {
            ItemStack stack = new ItemStack(this.selectedPart.getMaterials().getItem());
            this.field_146297_k.func_175599_af().func_175042_a(stack, this.field_146297_k.field_195558_d.func_198107_o() - 194, 30);
            int maxWidth = 140;
            int x = this.field_146297_k.field_195558_d.func_198107_o() - 150;
            int y = 35;
            String translatedName = this.selectedPart.getDisplayName(PartData.of(this.selectedPart), ItemStack.field_190927_a).func_150254_d();
            TextRenderUtils.renderScaled((FontRenderer)this.field_146297_k.field_71466_p, (String)translatedName, (int)x, (int)y, (float)1.0f, (int)0xFFFFFF, (boolean)false);
            String regName = TextFormatting.GRAY + this.selectedPart.getId().toString();
            TextRenderUtils.renderScaled((FontRenderer)this.field_146297_k.field_71466_p, (String)regName, (int)x, (int)(y + 10), (float)0.5f, (int)0xFFFFFF, (boolean)false);
            String typeName = this.selectedPart.getType().getDisplayName(this.selectedPart.getTier()).func_150254_d();
            TextRenderUtils.renderScaled((FontRenderer)this.field_146297_k.field_71466_p, (String)(TextFormatting.GREEN + typeName), (int)x, (int)(y + 16), (float)0.8f, (int)0xFFFFFF, (boolean)false);
            y += 30;
            for (Tuple<String, String> pair : this.selectedPartInfo) {
                this.field_146289_q.func_211126_b((String)pair.func_76341_a(), (float)x, (float)y, 0xFFFFFF);
                int width2 = this.field_146289_q.func_78256_a((String)pair.func_76340_b());
                this.field_146289_q.func_211126_b((String)pair.func_76340_b(), (float)(x + 140 - width2), (float)y, 0xFFFFFF);
                y += 10;
            }
        }
    }

    private static List<Tuple<String, String>> getPartInfo(IGearPart part) {
        ArrayList<Tuple<String, String>> list = new ArrayList<Tuple<String, String>>();
        PartData partData = PartData.of(part);
        for (ItemStat stat : ItemStat.ALL_STATS.values()) {
            StatInstance inst;
            Collection<StatInstance> modifiers = part.getStatModifiers(stat, partData);
            if (modifiers.isEmpty() || !(inst = stat.computeForDisplay(0.0f, MaterialGrade.NONE, modifiers)).shouldList(part, stat, true)) continue;
            boolean isZero = inst.getValue() == 0.0f;
            TextFormatting nameColor = isZero ? TextFormatting.DARK_GRAY : stat.displayColor;
            TextFormatting statColor = isZero ? TextFormatting.DARK_GRAY : TextFormatting.WHITE;
            String nameStr = nameColor + I18n.func_135052_a((String)("stat." + stat.getName().func_110624_b() + "." + stat.getName().func_110623_a()), (Object[])new Object[0]);
            int decimalPlaces = stat.displayAsInt && inst.getOp() != StatInstance.Operation.MUL1 && inst.getOp() != StatInstance.Operation.MUL2 ? 0 : 2;
            String statStr = statColor + inst.formattedString(decimalPlaces, false).replaceFirst("\\.0+$", "");
            if (statStr.contains(".")) {
                statStr = statStr.replaceFirst("0+$", "");
            }
            if (modifiers.size() > 1) {
                statStr = statStr + "*";
            }
            if (stat == CommonItemStats.ARMOR_DURABILITY) {
                statStr = statStr + "x";
            }
            list.add((Tuple<String, String>)new Tuple((Object)nameStr, (Object)statStr));
        }
        return list;
    }

    public static class PartButton
    extends GuiButton {
        private static final int SIZE = 16;
        final IGearPart part;

        PartButton(IGearPart part, int buttonId, int x, int y) {
            this(part, buttonId, x, y, 16, 16);
        }

        PartButton(IGearPart part, int buttonId, int x, int y, int widthIn, int heightIn) {
            super(buttonId, x, y, widthIn, heightIn, part.getId().toString());
            this.part = part;
        }

        public void func_194828_a(int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                ItemStack stack = new ItemStack(this.part.getMaterials().getItem());
                if (stack.func_190926_b()) {
                    stack = new ItemStack((IItemProvider)Blocks.field_180401_cv);
                }
                GlStateManager.func_179091_B();
                RenderHelper.func_74520_c();
                Minecraft.func_71410_x().func_175599_af().func_175042_a(stack, this.field_146128_h, this.field_146129_i);
                RenderHelper.func_74518_a();
                GlStateManager.func_179101_C();
            }
        }

        void drawHover(Minecraft mc, int mouseX, int mouseY) {
            if (this.func_146115_a()) {
                ItemStack craftingStack = new ItemStack(this.part.getMaterials().getItem());
                List tooltip = craftingStack.func_82840_a((EntityPlayer)mc.field_71439_g, () -> false).stream().map(ITextComponent::func_150254_d).collect(Collectors.toList());
                GuiUtils.preItemToolTip((ItemStack)craftingStack);
                tooltip.add(0, this.part.getDisplayName(null, ItemStack.field_190927_a).func_211708_a(TextFormatting.UNDERLINE).func_150254_d());
                GuiUtils.drawHoveringText(tooltip, (int)mouseX, (int)mouseY, (int)mc.field_195558_d.func_198105_m(), (int)mc.field_195558_d.func_198083_n(), (int)-1, (FontRenderer)mc.field_71466_p);
                GuiUtils.postItemToolTip();
            }
        }
    }
}

