/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.gui;

import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IInteractionObject;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.block.analyzer.ContainerPartAnalyzer;
import net.silentchaos512.gear.block.analyzer.GuiPartAnalyzer;
import net.silentchaos512.gear.block.analyzer.TilePartAnalyzer;
import net.silentchaos512.gear.block.craftingstation.ContainerCraftingStation;
import net.silentchaos512.gear.block.craftingstation.GuiCraftingStation;
import net.silentchaos512.gear.block.craftingstation.TileCraftingStation;
import net.silentchaos512.gear.block.salvager.ContainerSalvager;
import net.silentchaos512.gear.block.salvager.GuiSalvager;
import net.silentchaos512.gear.block.salvager.TileSalvager;
import net.silentchaos512.lib.inventory.TileEntityContainerType;

public enum GuiTypes {
    CRAFTING_STATION{

        @Override
        public Container getContainer(TileEntityContainerType<?> tileType, EntityPlayer player) {
            TileCraftingStation tileEntity = (TileCraftingStation)tileType.getTileEntity(player);
            return new ContainerCraftingStation(player, Objects.requireNonNull(tileEntity));
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public GuiContainer getGui(TileEntityContainerType<?> tileType, EntityPlayer player) {
            return new GuiCraftingStation((ContainerCraftingStation)tileType.func_174876_a(player.field_71071_by, player));
        }
    }
    ,
    PART_ANALYZER{

        @Override
        public Container getContainer(TileEntityContainerType<?> tileType, EntityPlayer player) {
            IInventory tileEntity = (IInventory)tileType.getTileEntity(player);
            return new ContainerPartAnalyzer(player.field_71071_by, Objects.requireNonNull(tileEntity));
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public GuiContainer getGui(TileEntityContainerType<?> tileType, EntityPlayer player) {
            TilePartAnalyzer tileEntity = (TilePartAnalyzer)tileType.getTileEntity(player);
            return new GuiPartAnalyzer(player.field_71071_by, Objects.requireNonNull(tileEntity));
        }
    }
    ,
    SALVAGER{

        @Override
        public Container getContainer(TileEntityContainerType<?> tileType, EntityPlayer player) {
            IInventory tileEntity = (IInventory)tileType.getTileEntity(player);
            return new ContainerSalvager(player.field_71071_by, Objects.requireNonNull(tileEntity));
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public GuiContainer getGui(TileEntityContainerType<?> tileType, EntityPlayer player) {
            TileSalvager tileEntity = (TileSalvager)tileType.getTileEntity(player);
            return new GuiSalvager(player.field_71071_by, Objects.requireNonNull(tileEntity));
        }
    };


    public void display(EntityPlayer player, BlockPos pos) {
        if (!(player instanceof EntityPlayerMP)) {
            SilentGear.LOGGER.error("Tried to send GUI packet from client?");
            return;
        }
        TileEntityContainerType<?> tileType = this.getContainerType(pos);
        Interactable containerSupplier = new Interactable(this, pos);
        NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)player), (IInteractionObject)containerSupplier, arg_0 -> tileType.toBytes(arg_0));
    }

    public ResourceLocation getId() {
        return new ResourceLocation("silentgear", this.name().toLowerCase(Locale.ROOT));
    }

    public <C extends Container> TileEntityContainerType<C> getContainerType() {
        return new TileEntityContainerType(this.getId());
    }

    public TileEntityContainerType<?> getContainerType(BlockPos pos) {
        return new TileEntityContainerType(this.getId(), pos);
    }

    public abstract Container getContainer(TileEntityContainerType<?> var1, EntityPlayer var2);

    @OnlyIn(value=Dist.CLIENT)
    public abstract GuiContainer getGui(TileEntityContainerType<?> var1, EntityPlayer var2);

    @OnlyIn(value=Dist.CLIENT)
    public static Optional<GuiTypes> from(FMLPlayMessages.OpenContainer msg) {
        for (GuiTypes type : GuiTypes.values()) {
            if (!type.getId().equals((Object)msg.getId())) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }

    static class Interactable
    implements IInteractionObject {
        private final GuiTypes type;
        private final BlockPos pos;

        Interactable(GuiTypes type, BlockPos pos) {
            this.type = type;
            this.pos = pos;
        }

        public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
            return this.type.getContainer(this.type.getContainerType(this.pos), playerIn);
        }

        public String func_174875_k() {
            return this.type.getId().toString();
        }

        public ITextComponent func_200200_C_() {
            ResourceLocation id = this.type.getId();
            return new TextComponentTranslation("container." + id.func_110624_b() + "." + id.func_110623_a(), new Object[0]);
        }

        public boolean func_145818_k_() {
            return false;
        }

        @Nullable
        public ITextComponent func_200201_e() {
            return null;
        }
    }
}

