/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.IPartPosition;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.client.ColorHandlers;
import net.silentchaos512.gear.client.models.AbstractToolModel;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.item.gear.CoreBow;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartManager;
import net.silentchaos512.gear.parts.PartPositions;
import net.silentchaos512.gear.parts.type.PartMain;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public final class ToolModel
implements IUnbakedModel {
    private static final IUnbakedModel MODEL = new ToolModel();
    public static final Map<UUID, Float> bowPull = new HashMap<UUID, Float>();
    private final ImmutableMap<String, String> textures;

    private ToolModel() {
        this.textures = ImmutableMap.of();
    }

    private ToolModel(ImmutableMap<String, String> textures) {
        this.textures = textures;
    }

    public ToolModel retexture(ImmutableMap<String, String> textures) {
        return new ToolModel(textures);
    }

    public ToolModel process(ImmutableMap<String, String> customData) {
        return new ToolModel(customData);
    }

    public Collection<ResourceLocation> func_187965_e() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> func_209559_a(Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ICoreTool item : ModItems.toolClasses.values()) {
            GearType toolClass = item.getGearType();
            boolean hasGuard = item.hasSwordGuard();
            for (int frame = 0; frame < item.getAnimationFrames(); ++frame) {
                for (IGearPart part : PartManager.getValues()) {
                    ResourceLocation texGuard;
                    ResourceLocation texBroken;
                    PartData partData = PartData.of(part);
                    ResourceLocation texBasic = partData.getTexture(ItemStack.field_190927_a, toolClass, part.getPartPosition(), frame);
                    if (texBasic != null) {
                        builder.add((Object)texBasic);
                    }
                    if ((texBroken = partData.getBrokenTexture(ItemStack.field_190927_a, toolClass, part.getPartPosition())) != null) {
                        builder.add((Object)texBroken);
                    }
                    if (!hasGuard || !(part instanceof PartMain) || (texGuard = partData.getTexture(ItemStack.field_190927_a, toolClass, PartPositions.GUARD, frame)) == null) continue;
                    builder.add((Object)texGuard);
                }
            }
        }
        return builder.build();
    }

    public IBakedModel bake(Function<ResourceLocation, IUnbakedModel> modelGetter, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, IModelState state, boolean uvlock, VertexFormat format) {
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((IModelState)state);
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableList textures = (ImmutableList)IPartPosition.RENDER_LAYERS.stream().map(IPartPosition::getModelIndex).map(arg_0 -> this.textures.get(arg_0)).filter(Objects::nonNull).map(ResourceLocation::new).collect(ImmutableList.toImmutableList());
        IBakedModel model = new ItemLayerModel(textures).bake(modelGetter, spriteGetter, state, uvlock, format);
        builder.addAll((Iterable)model.func_200117_a(null, null, SilentGear.random));
        int layerCount = textures.size();
        return new Baked((IModel)this, ToolModel.createQuadsMap(model, layerCount), format, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)Maps.immutableEnumMap((Map)transformMap), new HashMap<String, IBakedModel>());
    }

    private static ImmutableList<ImmutableList<BakedQuad>> createQuadsMap(IBakedModel model, int layerCount) {
        ArrayList<ImmutableList.Builder> list = new ArrayList<ImmutableList.Builder>();
        for (int i = 0; i < layerCount; ++i) {
            list.add(ImmutableList.builder());
        }
        for (BakedQuad quad : model.func_200117_a(null, null, SilentGear.random)) {
            ((ImmutableList.Builder)list.get(quad.func_178211_c())).add((Object)quad);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ImmutableList.Builder b : list) {
            builder.add((Object)b.build());
        }
        return builder.build();
    }

    @Nonnull
    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public static final class Baked
    extends AbstractToolModel {
        public static Baked instance;

        Baked(IModel parent, ImmutableList<ImmutableList<BakedQuad>> immutableList, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, Map<String, IBakedModel> cache) {
            super(parent, immutableList, format, transforms, cache);
            instance = this;
        }

        @Nonnull
        public ItemOverrideList func_188617_f() {
            return OverrideHandler.INSTANCE;
        }

        public boolean func_188618_c() {
            return true;
        }
    }

    private static final class OverrideHandler
    extends ItemOverrideList {
        public static final OverrideHandler INSTANCE = new OverrideHandler();

        private OverrideHandler() {
        }

        @Nullable
        public IBakedModel func_209581_a(IBakedModel parentModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            if (!(stack.func_77973_b() instanceof ICoreTool)) {
                return parentModel;
            }
            int animationFrame = this.getAnimationFrame(stack, world, entity);
            String key = GearData.getCachedModelKey(stack, animationFrame);
            stack.func_196082_o().func_74778_a("debug_modelkey", key);
            if (!GearClientHelper.modelCache.containsKey(key)) {
                ICoreTool itemTool = (ICoreTool)stack.func_77973_b();
                GearType toolClass = itemTool.getGearType();
                boolean isBroken = GearHelper.isBroken(stack);
                PartDataList parts = GearData.getConstructionParts(stack);
                LinkedHashMap<IPartPosition, PartData> renderLayers = new LinkedHashMap<IPartPosition, PartData>();
                for (IPartPosition position : IPartPosition.RENDER_LAYERS) {
                    if (position == PartPositions.HEAD) {
                        renderLayers.put(PartPositions.HEAD, itemTool.getPrimaryPart(stack));
                        continue;
                    }
                    if (position == PartPositions.GUARD && itemTool.hasSwordGuard()) {
                        renderLayers.put(PartPositions.GUARD, itemTool.getSecondaryPart(stack));
                        continue;
                    }
                    if (position == PartPositions.ROD) {
                        renderLayers.put(PartPositions.ROD, itemTool.getRodPart(stack));
                        continue;
                    }
                    PartData part2 = parts.firstInPosition(position);
                    if (part2 == null) continue;
                    renderLayers.put(position, part2);
                }
                ImmutableMap.Builder builder = ImmutableMap.builder();
                renderLayers.forEach((pos, part) -> OverrideHandler.processTexture(stack, toolClass, pos, part, animationFrame, isBroken, (ImmutableMap.Builder<String, String>)builder));
                Baked model = (Baked)parentModel;
                IModel parent = model.getParent().retexture(builder.build());
                Function<ResourceLocation, IUnbakedModel> modelGetter = location -> null;
                Function<ResourceLocation, TextureAtlasSprite> spriteGetter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                IBakedModel bakedModel = parent.bake(modelGetter, spriteGetter, (IModelState)new SimpleModelState(ImmutableMap.of()), false, model.getVertexFormat());
                GearClientHelper.modelCache.put(key, bakedModel);
                ColorHandlers.gearColorCache.put(key, (Integer[])renderLayers.values().stream().map(part -> part.getColor(stack, animationFrame)).toArray(Integer[]::new));
                return bakedModel;
            }
            return GearClientHelper.modelCache.get(key);
        }

        private static void processTexture(ItemStack stack, GearType toolClass, IPartPosition position, @Nullable PartData part, int animationFrame, boolean isBroken, ImmutableMap.Builder<String, String> builder) {
            if (part != null) {
                ResourceLocation texture;
                ResourceLocation resourceLocation = texture = isBroken ? part.getBrokenTexture(stack, toolClass, position) : part.getTexture(stack, toolClass, position, animationFrame);
                if (texture != null) {
                    builder.put((Object)position.getModelIndex(), (Object)texture.toString());
                }
            }
        }

        private int getAnimationFrame(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            UUID uuid;
            if (stack.func_77973_b() instanceof CoreBow && bowPull.containsKey(uuid = GearData.getUUID(stack))) {
                float pull = bowPull.get(uuid).floatValue();
                if (pull > 0.9f) {
                    return 3;
                }
                if (pull > 0.65f) {
                    return 2;
                }
                return 1;
            }
            return 0;
        }
    }

    public static final class Loader
    implements ICustomModelLoader {
        public static Loader INSTANCE = new Loader();

        public void func_195410_a(IResourceManager resourceManager) {
            SilentGear.LOGGER.debug("ToolModel.Loader#onResourceManagerReload");
        }

        public boolean accepts(@Nonnull ResourceLocation modelLocation) {
            boolean matchesPath = ModItems.toolClasses.keySet().stream().anyMatch(s -> modelLocation.func_110623_a().equals(s));
            return modelLocation.func_110624_b().equals("silentgear") && matchesPath;
        }

        @Nonnull
        public IUnbakedModel loadModel(@Nonnull ResourceLocation modelLocation) {
            return MODEL;
        }
    }
}

