/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.CommonItemStats;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.client.util.TooltipFlagTC;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.item.gear.CoreArmor;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.utils.config.BooleanValue;

@OnlyIn(value=Dist.CLIENT)
public final class GearClientHelper {
    public static Map<String, IBakedModel> modelCache = new HashMap<String, IBakedModel>();

    private GearClientHelper() {
    }

    public static void addInformation(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        TooltipFlagTC flagTC = flag instanceof TooltipFlagTC ? (TooltipFlagTC)flag : TooltipFlagTC.withModifierKeys(flag.func_194127_a(), true, true);
        GearClientHelper.addInformation(stack, world, tooltip, flagTC);
    }

    public static void addInformation(ItemStack stack, World world, List<ITextComponent> tooltip, TooltipFlagTC flag) {
        NBTTagCompound tagCompound;
        PartDataList constructionParts;
        if (!(stack.func_77973_b() instanceof ICoreItem)) {
            return;
        }
        boolean ctrlDown = flag.ctrlDown;
        boolean altDown = flag.altDown;
        ICoreItem item = (ICoreItem)stack.func_77973_b();
        if (GearHelper.isBroken(stack)) {
            tooltip.add(1, GearClientHelper.misc("broken", new Object[0]).func_211708_a(TextFormatting.RED));
        }
        if (GearData.isExampleGear(stack)) {
            tooltip.add(1, GearClientHelper.misc("exampleOutput1", new Object[0]).func_211708_a(TextFormatting.YELLOW));
            tooltip.add(2, GearClientHelper.misc("exampleOutput2", new Object[0]).func_211708_a(TextFormatting.YELLOW));
        }
        if ((constructionParts = GearData.getConstructionParts(stack)).getMains().isEmpty()) {
            tooltip.add(GearClientHelper.misc("invalidParts", new Object[0]).func_211708_a(TextFormatting.RED));
            tooltip.add(GearClientHelper.misc("lockedStats", new Object[0]).func_211708_a(TextFormatting.RED));
        } else if (GearData.hasLockedStats(stack)) {
            tooltip.add(GearClientHelper.misc("lockedStats", new Object[0]).func_211708_a(TextFormatting.YELLOW));
        } else {
            if (item.requiresPartOfType(PartType.ROD) && constructionParts.getRods().isEmpty()) {
                tooltip.add(GearClientHelper.misc("missingRod", new Object[0]).func_211708_a(TextFormatting.RED));
            }
            if (item.requiresPartOfType(PartType.BOWSTRING) && constructionParts.getPartsOfType(PartType.BOWSTRING).isEmpty()) {
                tooltip.add(GearClientHelper.misc("missingBowstring", new Object[0]).func_211708_a(TextFormatting.RED));
            }
        }
        Collections.reverse(constructionParts);
        for (PartData data : constructionParts) {
            data.getPart().addInformation(data, stack, tooltip, flag);
        }
        TraitHelper.getTraits(stack, constructionParts).forEach((trait, level) -> tooltip.add(trait.getDisplayName((int)level)));
        float synergyDisplayValue = GearData.getSynergyDisplayValue(stack);
        TextFormatting color = synergyDisplayValue < 1.0f ? TextFormatting.RED : (synergyDisplayValue > 1.0f ? TextFormatting.GREEN : TextFormatting.WHITE);
        tooltip.add((ITextComponent)new TextComponentString("Synergy: " + color + String.format("%d%%", (int)(100.0f * synergyDisplayValue))));
        if (flag.func_194127_a() && (tagCompound = stack.func_196082_o()).func_74764_b("debug_modelkey")) {
            tooltip.add(new TextComponentString(tagCompound.func_74779_i("debug_modelkey")).func_211708_a(TextFormatting.DARK_GRAY));
        }
        ITextComponent textStats = GearClientHelper.misc("tooltip.stats", new Object[0]).func_211708_a(TextFormatting.GOLD);
        if (ctrlDown && flag.showStats) {
            tooltip.add(textStats);
            Collection<ItemStat> relevantStats = flag.func_194127_a() && SilentGear.isDevBuild() ? ItemStat.ALL_STATS.values() : item.getRelevantStats(stack);
            for (ItemStat stat : relevantStats) {
                float statValue = GearData.getStat(stack, stat);
                float totalArmor = -1.0f;
                if (item instanceof CoreArmor) {
                    if (stat == CommonItemStats.ARMOR) {
                        totalArmor = statValue;
                        statValue = (float)((CoreArmor)item).getArmorProtection(stack);
                    } else if (stat == CommonItemStats.ARMOR_TOUGHNESS) {
                        totalArmor = statValue;
                        statValue /= 4.0f;
                    }
                }
                StatInstance inst = new StatInstance("display_" + stat.getName(), statValue, StatInstance.Operation.AVG);
                ITextComponent textName = new TextComponentString("- ").func_150257_a(stat.getDisplayName());
                TextComponentString textStat = new TextComponentString(inst.formattedString(stat.displayAsInt ? 0 : 1, false));
                if (stat == CommonItemStats.DURABILITY) {
                    int durabilityLeft = stack.func_77958_k() - stack.func_77952_i();
                    int durabilityMax = stack.func_77958_k();
                    textStat = GearClientHelper.statText("durabilityFormat", durabilityLeft, durabilityMax);
                } else if (stat == CommonItemStats.ARMOR || stat == CommonItemStats.ARMOR_TOUGHNESS) {
                    String str1 = String.format("%.1f", Float.valueOf(statValue));
                    String str2 = String.format("%.1f", Float.valueOf(totalArmor));
                    textStat = GearClientHelper.statText("armorFormat", str1, str2);
                }
                tooltip.add(GearClientHelper.statText("displayFormat", textName, textStat));
            }
        } else if (flag.showStats) {
            textStats.func_150258_a(" ").func_150257_a(GearClientHelper.misc("tooltip.stats.key", new Object[0]).func_211708_a(TextFormatting.GRAY));
            tooltip.add(textStats);
        }
        ITextComponent textConstruction = GearClientHelper.misc("tooltip.construction", new Object[0]).func_211708_a(TextFormatting.GOLD);
        if (altDown && flag.showConstruction) {
            tooltip.add(textConstruction);
            Collections.reverse(constructionParts);
            GearClientHelper.tooltipListParts(stack, tooltip, constructionParts);
        } else if (flag.showConstruction) {
            textConstruction.func_150257_a(new TextComponentString(" ").func_211708_a(TextFormatting.GRAY).func_150257_a(GearClientHelper.misc("tooltip.construction.key", new Object[0])));
            tooltip.add(textConstruction);
        }
    }

    private static ITextComponent misc(String key, Object ... formatArgs) {
        return new TextComponentTranslation("misc.silentgear." + key, formatArgs);
    }

    private static ITextComponent statText(String key, Object ... formatArgs) {
        return new TextComponentTranslation("stat.silentgear." + key, formatArgs);
    }

    public static void tooltipListParts(ItemStack gear, List<ITextComponent> tooltip, Collection<PartData> parts) {
        for (PartData part : parts) {
            ITextComponent text = new TextComponentString("- ").func_150257_a(part.getDisplayName(gear));
            if (part.getPart().getType() == PartType.MAIN) {
                ITextComponent gradeText = new TextComponentString(" (").func_211708_a(TextFormatting.RESET).func_150257_a(part.getGrade().getDisplayName()).func_150258_a(")");
                text.func_150257_a(gradeText);
            }
            tooltip.add(text);
        }
    }

    public static boolean hasEffect(ItemStack stack) {
        BooleanValue allowEnchantedEffect = Config.CLIENT.allowEnchantedEffect;
        if (allowEnchantedEffect == null) {
            SilentGear.LOGGER.debug("null!");
            return false;
        }
        return (Boolean)allowEnchantedEffect.get() != false && stack.func_77948_v();
    }

    public static boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.equals(newStack);
    }

    public static Map<String, PartData> getRenderParts(ItemStack stack) {
        LinkedHashMap<String, PartData> map = new LinkedHashMap<String, PartData>();
        ICoreTool item = (ICoreTool)stack.func_77973_b();
        GearType itemClass = item.getGearType();
        boolean hasGuard = item.hasSwordGuard();
        PartData partHead = item.getPrimaryPart(stack);
        PartData partGuard = hasGuard ? item.getSecondaryPart(stack) : null;
        PartData partRod = item.getRodPart(stack);
        PartData partTip = item.getTipPart(stack);
        PartData partBowstring = item.getBowstringPart(stack);
        if (partRod != null) {
            map.put("rod", partRod);
        }
        if (partHead != null) {
            map.put("head", partHead);
        }
        if (partGuard != null) {
            map.put("guard", partGuard);
        }
        if (partTip != null) {
            map.put("tip", partTip);
        }
        if (partBowstring != null) {
            map.put("bowstring", partBowstring);
        }
        return map;
    }
}

