/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartManager;
import net.silentchaos512.gear.util.GearData;

public final class SGearPartsCommand {
    private static final SuggestionProvider<CommandSource> partIdSuggestions = (ctx, builder) -> ISuggestionProvider.func_212476_a(PartManager.getValues().stream().map(IGearPart::getId), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSource> partInGearSuggestions = (ctx, builder) -> {
        PartDataList parts = GearData.getConstructionParts(SGearPartsCommand.getGear((CommandContext<CommandSource>)ctx));
        return ISuggestionProvider.func_212476_a(parts.getUniqueParts(false).stream().map(part -> part.getPart().getId()), (SuggestionsBuilder)builder);
    };

    private SGearPartsCommand() {
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"sgear_parts").requires(source -> source.func_197034_c(2));
        builder.then(Commands.func_197057_a((String)"add").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"partID", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(partIdSuggestions).then(Commands.func_197056_a((String)"grade", (ArgumentType)new MaterialGrade.Argument()).executes(ctx -> SGearPartsCommand.runAdd((CommandContext<CommandSource>)ctx, SGearPartsCommand.getPartGrade((CommandContext<CommandSource>)ctx))))).executes(ctx -> SGearPartsCommand.runAdd((CommandContext<CommandSource>)ctx, MaterialGrade.NONE))));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"partID", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(partInGearSuggestions).executes(SGearPartsCommand::runRemoveById))).then(Commands.func_197056_a((String)"partIndex", (ArgumentType)IntegerArgumentType.integer()).executes(SGearPartsCommand::runRemoveByIndex)));
        builder.then(Commands.func_197057_a((String)"list").executes(SGearPartsCommand::runList));
        dispatcher.register(builder);
    }

    private static int runAdd(CommandContext<CommandSource> ctx, MaterialGrade grade) throws CommandSyntaxException {
        IGearPart part = SGearPartsCommand.getPart(ctx);
        if (part == null) {
            return 0;
        }
        ItemStack gear = SGearPartsCommand.getGear(ctx);
        if (gear.func_190926_b()) {
            return 0;
        }
        PartDataList partList = GearData.getConstructionParts(gear);
        partList.add(PartData.of(part, grade));
        GearData.writeConstructionParts(gear, partList);
        GearData.recalculateStats((EntityPlayer)((CommandSource)ctx.getSource()).func_197035_h(), gear);
        return 1;
    }

    private static int runRemoveById(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ItemStack gear = SGearPartsCommand.getGear(ctx);
        if (gear.func_190926_b()) {
            return 0;
        }
        IGearPart part = SGearPartsCommand.getPart(ctx);
        if (part == null) {
            return 0;
        }
        PartDataList partList = GearData.getConstructionParts(gear);
        boolean removed = false;
        for (int i = 0; !removed && i < partList.size(); ++i) {
            PartData data = partList.get(i);
            if (data.getPart() != part) continue;
            partList.remove(data);
            removed = true;
        }
        if (removed) {
            GearData.writeConstructionParts(gear, partList);
            ((CommandSource)ctx.getSource()).func_197030_a(SGearPartsCommand.text("remove.success", new Object[0]), true);
            return 1;
        }
        ((CommandSource)ctx.getSource()).func_197021_a(SGearPartsCommand.text("gearDoesNotContainPart", new Object[0]));
        return 0;
    }

    private static int runRemoveByIndex(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ItemStack gear = SGearPartsCommand.getGear(ctx);
        if (gear.func_190926_b()) {
            return 0;
        }
        PartDataList partList = GearData.getConstructionParts(gear);
        int index = IntegerArgumentType.getInteger(ctx, (String)"partIndex");
        if (index < 0 || index >= partList.size()) {
            ((CommandSource)ctx.getSource()).func_197021_a(SGearPartsCommand.text("indexOutOfBounds", new Object[0]));
            return 0;
        }
        partList.remove(index);
        GearData.writeConstructionParts(gear, partList);
        ((CommandSource)ctx.getSource()).func_197030_a(SGearPartsCommand.text("remove.success", new Object[0]), true);
        return 1;
    }

    private static int runList(CommandContext<CommandSource> context) {
        String listStr = PartManager.getValues().stream().map(part -> part.getId().toString()).collect(Collectors.joining(", "));
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TextComponentString(listStr), true);
        for (PartType type : PartType.getValues()) {
            int count = PartManager.getPartsOfType(type).size();
            String str = String.format("%s: %d", type.getName(), count);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TextComponentString(str), true);
        }
        return 1;
    }

    @Nullable
    private static IGearPart getPart(CommandContext<CommandSource> ctx) {
        ResourceLocation id = ResourceLocationArgument.func_197195_e(ctx, (String)"partID");
        IGearPart part = PartManager.get(id);
        if (part == null) {
            ((CommandSource)ctx.getSource()).func_197021_a(SGearPartsCommand.text("partNotFound", id));
        }
        return part;
    }

    private static MaterialGrade getPartGrade(CommandContext<CommandSource> ctx) {
        MaterialGrade grade = MaterialGrade.Argument.getGrade(ctx, "grade");
        return grade;
    }

    private static ItemStack getGear(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        if (((CommandSource)ctx.getSource()).func_197022_f() instanceof EntityPlayerMP) {
            ItemStack gear = ((CommandSource)ctx.getSource()).func_197035_h().func_184614_ca();
            if (gear.func_77973_b() instanceof ICoreItem) {
                return gear;
            }
        } else {
            ((CommandSource)ctx.getSource()).func_197021_a(SGearPartsCommand.text("sourceMustBePlayer", new Object[0]));
        }
        return ItemStack.field_190927_a;
    }

    private static ITextComponent text(String key, Object ... args) {
        return new TextComponentTranslation("command.silentgear.parts." + key, args);
    }
}

