/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.jei;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.compat.jei.SGearJeiPlugin;
import net.silentchaos512.gear.init.ModBlocks;

public class PartAnalyzerCategory
implements IRecipeCategory<Recipe> {
    private static final int GUI_START_X = 0;
    private static final int GUI_START_Y = 0;
    private static final int GUI_WIDTH = 72;
    private static final int GUI_HEIGHT = 38;
    private static final Tag<Item> CATALYSTS_TAG1 = new ItemTags.Wrapper(SilentGear.getId("analyzer_catalyst/tier1"));
    private static final Tag<Item> CATALYSTS_TAG2 = new ItemTags.Wrapper(SilentGear.getId("analyzer_catalyst/tier2"));
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final String localizedName;

    public PartAnalyzerCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(SGearJeiPlugin.GUI_TEXTURE, 0, 0, 72, 38);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.PART_ANALYZER));
        this.arrow = guiHelper.drawableBuilder(SGearJeiPlugin.GUI_TEXTURE, 72, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.localizedName = I18n.func_135052_a((String)"category.silentgear.part_analyzer", (Object[])new Object[0]);
    }

    public ResourceLocation getUid() {
        return SGearJeiPlugin.PART_ANALYZER;
    }

    public Class<? extends Recipe> getRecipeClass() {
        return Recipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(Recipe recipe, IIngredients ingredients) {
        List<ItemStack> materials = recipe.getInputs();
        List<ItemStack> catalysts = recipe.getCatalysts();
        ingredients.setInputLists(VanillaTypes.ITEM, Arrays.asList(materials, catalysts));
        ArrayList outputs = new ArrayList();
        for (MaterialGrade grade : MaterialGrade.values()) {
            if (grade == MaterialGrade.NONE) continue;
            outputs.addAll(materials.stream().map(grade::applyTo).collect(Collectors.toList()));
        }
        ingredients.setOutputLists(VanillaTypes.ITEM, Collections.singletonList(outputs));
    }

    public void setRecipe(IRecipeLayout recipeLayout, Recipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 0, 0);
        itemStacks.init(1, true, 0, 20);
        itemStacks.init(2, false, 54, 0);
        itemStacks.set(ingredients);
    }

    public void draw(Recipe recipe, double mouseX, double mouseY) {
        this.arrow.draw(24, 0);
    }

    static final class Recipe {
        final IGearPart part;

        Recipe(IGearPart part) {
            this.part = part;
        }

        boolean isValid() {
            return !this.getInputs().isEmpty();
        }

        List<ItemStack> getInputs() {
            Ingredient ingredient = this.part.getMaterials().getIngredient();
            if (ingredient == null) {
                return ImmutableList.of();
            }
            return Arrays.stream(ingredient.func_193365_a()).collect(Collectors.toList());
        }

        List<ItemStack> getCatalysts() {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            list.addAll(CATALYSTS_TAG1.func_199885_a().stream().map(ItemStack::new).collect(Collectors.toList()));
            list.addAll(CATALYSTS_TAG2.func_199885_a().stream().map(ItemStack::new).collect(Collectors.toList()));
            return list;
        }
    }
}

