/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.jei;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.compat.jei.PartAnalyzerCategory;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.parts.PartManager;

@JeiPlugin
public class SGearJeiPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_UID = SilentGear.getId("plugin/main");
    static final ResourceLocation PART_ANALYZER = SilentGear.getId("category/part_analyzer");
    static final ResourceLocation GUI_TEXTURE = SilentGear.getId("textures/gui/recipe_display.png");
    private static boolean initFailed = false;

    public static boolean hasInitFailed() {
        return initFailed;
    }

    public ResourceLocation getPluginUid() {
        return PLUGIN_UID;
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        initFailed = true;
        IGuiHelper guiHelper = reg.getJeiHelpers().getGuiHelper();
        reg.addRecipeCategories(new IRecipeCategory[]{new PartAnalyzerCategory(guiHelper)});
        initFailed = false;
    }

    public void registerRecipes(IRecipeRegistration reg) {
        initFailed = true;
        reg.addRecipes((Collection)PartManager.getMains().stream().map(PartAnalyzerCategory.Recipe::new).filter(PartAnalyzerCategory.Recipe::isValid).collect(Collectors.toList()), PART_ANALYZER);
        SGearJeiPlugin.addInfoPage(reg, (IItemProvider)ModBlocks.CRAFTING_STATION);
        SGearJeiPlugin.addInfoPage(reg, (IItemProvider)ModBlocks.PART_ANALYZER);
        SGearJeiPlugin.addInfoPage(reg, "tip_upgrade", PartManager.getPartsOfType(PartType.TIP).stream().flatMap(part -> {
            Ingredient ingredient = part.getMaterials().getIngredient();
            return ingredient != null ? Arrays.stream(ingredient.func_193365_a()) : Stream.of(new ItemStack[0]);
        }).map(ItemStack::func_77973_b).collect(Collectors.toList()));
        SGearJeiPlugin.addInfoPage(reg, CraftingItems.RED_CARD_UPGRADE);
        SGearJeiPlugin.addInfoPage(reg, CraftingItems.SPOON_UPGRADE);
        for (ICoreItem item : ModItems.gearClasses.values()) {
            SGearJeiPlugin.addInfoPage(reg, item);
        }
        initFailed = false;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        reg.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.CRAFTING_STATION), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
        reg.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.PART_ANALYZER), new ResourceLocation[]{PART_ANALYZER});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration reg) {
    }

    public void registerItemSubtypes(ISubtypeRegistration reg) {
        initFailed = true;
        initFailed = false;
    }

    private static void addInfoPage(IRecipeRegistration reg, IItemProvider item) {
        String key = SGearJeiPlugin.getDescKey(Objects.requireNonNull(item.func_199767_j().getRegistryName()));
        ItemStack stack = new ItemStack(item);
        reg.addIngredientInfo((Object)stack, VanillaTypes.ITEM, new String[]{key});
    }

    private static void addInfoPage(IRecipeRegistration reg, String name, Collection<IItemProvider> items) {
        String key = SGearJeiPlugin.getDescKey(SilentGear.getId(name));
        List stacks = items.stream().map(ItemStack::new).collect(Collectors.toList());
        reg.addIngredientInfo(stacks, VanillaTypes.ITEM, new String[]{key});
    }

    private static void addInfoPage(IRecipeRegistration reg, IItemProvider item, Stream<ItemStack> variants) {
        String key = SGearJeiPlugin.getDescKey(Objects.requireNonNull(item.func_199767_j().getRegistryName()));
        reg.addIngredientInfo(variants.collect(Collectors.toList()), VanillaTypes.ITEM, new String[]{key});
    }

    private static String getDescKey(ResourceLocation name) {
        return "jei." + name.func_110624_b() + "." + name.func_110623_a() + ".desc";
    }
}

