/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.item.blueprint.BlueprintType;
import net.silentchaos512.gear.util.IAOETool;
import net.silentchaos512.utils.config.BooleanValue;
import net.silentchaos512.utils.config.ConfigSpecWrapper;
import net.silentchaos512.utils.config.ConfigValue;
import net.silentchaos512.utils.config.DoubleValue;
import net.silentchaos512.utils.config.EnumValue;

public class Config {
    private static final ConfigSpecWrapper WRAPPER_CLIENT = ConfigSpecWrapper.create((Path)FMLPaths.CONFIGDIR.get().resolve("silentgear-client.toml"));
    private static final ConfigSpecWrapper WRAPPER = ConfigSpecWrapper.create((Path)FMLPaths.CONFIGDIR.get().resolve("silentgear-common.toml"));
    public static final Client CLIENT = new Client(WRAPPER_CLIENT);
    public static final General GENERAL = new General(WRAPPER);

    private Config() {
    }

    public static void init() {
        WRAPPER_CLIENT.validate();
        WRAPPER_CLIENT.validate();
        WRAPPER.validate();
        WRAPPER.validate();
    }

    private static String[] getDefaultNerfedGear() {
        ImmutableSet toolTypes = ImmutableSet.of((Object)"pickaxe", (Object)"shovel", (Object)"axe", (Object)"sword");
        ImmutableSet toolMaterials = ImmutableSet.of((Object)"wooden", (Object)"stone", (Object)"iron", (Object)"golden", (Object)"diamond");
        List<String> items = toolTypes.stream().flatMap(arg_0 -> Config.lambda$getDefaultNerfedGear$1((Set)toolMaterials, arg_0)).collect(Collectors.toList());
        ImmutableSet armorTypes = ImmutableSet.of((Object)"helmet", (Object)"chestplate", (Object)"leggings", (Object)"boots");
        ImmutableSet armorMaterials = ImmutableSet.of((Object)"leather", (Object)"chainmail", (Object)"iron", (Object)"diamond", (Object)"golden");
        items.addAll(armorTypes.stream().flatMap(arg_0 -> Config.lambda$getDefaultNerfedGear$3((Set)armorMaterials, arg_0)).collect(Collectors.toList()));
        return items.toArray(new String[0]);
    }

    private static /* synthetic */ Stream lambda$getDefaultNerfedGear$3(Set armorMaterials, String type) {
        return armorMaterials.stream().map(material -> "minecraft:" + material + "_" + type);
    }

    private static /* synthetic */ Stream lambda$getDefaultNerfedGear$1(Set toolMaterials, String type) {
        return toolMaterials.stream().map(material -> "minecraft:" + material + "_" + type);
    }

    public static class Client {
        public final BooleanValue allowEnchantedEffect;
        public final BooleanValue useLiteModels;

        Client(ConfigSpecWrapper wrapper) {
            this.allowEnchantedEffect = wrapper.builder("gear.allowEnchantedEffect").comment("Allow gear items to have the 'enchanted glow' effect. Set to 'false' to disable the effect.", new String[]{"The way vanilla handles the effect is bugged, and it is recommended to disable this until custom models are possible again."}).define(false);
            this.useLiteModels = wrapper.builder("gear.useLiteModels").comment("Use 'lite' gear models. These should be easier on some systems, but do not allow unique textures for different materials.", new String[]{"Currently, this option has no effect, as the normal model system is not working yet (lite models are used)"}).define(false);
        }
    }

    public static class General {
        public final EnumValue<BlueprintType> blueprintTypes;
        public final BooleanValue spawnWithStarterBlueprints;
        final ConfigValue<List<? extends String>> placerTools;
        final ConfigValue<List<? extends String>> placeableItems;
        public final DoubleValue sinewDropRate;
        final ConfigValue<List<? extends String>> sinewAnimals;
        public final EnumValue<IAOETool.MatchMode> matchModeStandard;
        public final EnumValue<IAOETool.MatchMode> matchModeOres;
        public final BooleanValue gearBreaksPermanently;
        public final DoubleValue repairFactorAnvil;
        public final DoubleValue repairFactorQuick;
        public final BooleanValue upgradesInAnvilOnly;
        public final DoubleValue salvagerMinLossRate;
        public final DoubleValue salvagerMaxLossRate;

        General(ConfigSpecWrapper wrapper) {
            wrapper.comment("item.blueprint", "Blueprint and template settings");
            this.blueprintTypes = wrapper.builder("item.blueprint.typesAllowed").comment("Allowed blueprint types. Valid values are: BOTH, BLUEPRINT, and TEMPLATE").defineEnum((Enum)BlueprintType.BOTH);
            this.spawnWithStarterBlueprints = wrapper.builder("item.blueprint.spawnWithStarterBlueprints").comment("When joining a new world, should players be given a blueprint package?", new String[]{"The blueprint package gives some blueprints when used (right-click).", "To change what is given, override the starter_blueprints loot table."}).define(true);
            wrapper.comment("item.blockPlacers", "Silent Gear allows some items to be used to place blocks.", new String[]{"You can change which items place blocks and what other items they can activate."});
            this.placerTools = wrapper.builder("item.blockPlacers.placerTools").comment("These items are able to place blocks. The player must be sneaking.").defineList((List)ImmutableList.of((Object)"silentgear:axe", (Object)"silentgear:pickaxe", (Object)"silentgear:shovel"), o -> o instanceof String && ResourceLocation.func_208304_a((String)((String)o)) != null);
            this.placeableItems = wrapper.builder("item.blockPlacers.placeableItems").comment("These items can be used by placer tools. The player must be sneaking.", new String[]{"Note that some items may not work with this feature."}).defineList((List)ImmutableList.of((Object)"danknull:dank_null", (Object)"torchbandolier:torch_bandolier", (Object)"xreliquary:sojourner_staff"), o -> o instanceof String && ResourceLocation.func_208304_a((String)((String)o)) != null);
            wrapper.comment("item.sinew", "Settings for sinew drops");
            this.sinewDropRate = wrapper.builder("item.sinew.dropRate").comment("Drop rate of sinew (chance out of 1)").defineInRange(0.2, 0.0, 1.0);
            this.sinewAnimals = wrapper.builder("item.sinew.dropsFrom").comment("These entities can drop sinew when killed.").defineList((List)ImmutableList.of((Object)"minecraft:cow", (Object)"minecraft:pig", (Object)"minecraft:sheep"), o -> o instanceof String && ResourceLocation.func_208304_a((String)((String)o)) != null);
            wrapper.comment("item.gear", "Settings for gear (tools, weapons, and armor)");
            wrapper.comment("item.gear.aoeTools", "Settings for AOE tools (hammer, excavator)", new String[]{"Match modes determine what blocks are considered similar enough to be mined together.", "LOOSE: Break anything (you probably do not want this)", "MODERATE: Break anything with the same harvest level", "STRICT: Break only the exact same block"});
            this.matchModeStandard = wrapper.builder("item.gear.aoeTools.matchMode.standard").comment("Match mode for most blocks").defineEnum((Enum)IAOETool.MatchMode.MODERATE);
            this.matchModeOres = wrapper.builder("item.gear.aoeTools.matchMode.ores").comment("Match mode for ore blocks (anything in the forge:ores block tag)").defineEnum((Enum)IAOETool.MatchMode.STRICT);
            this.gearBreaksPermanently = wrapper.builder("item.gear.breaksPermanently").comment("If true, gear breaks permanently, like vanilla tools and armor").define(false);
            this.repairFactorAnvil = wrapper.builder("item.gear.repairs.anvilEffectiveness").comment("Effectiveness of gear repairs done in an anvil. Set to 0 to disable anvil repairs.").defineInRange(0.5, 0.0, 1.0);
            this.repairFactorQuick = wrapper.builder("item.gear.repairs.quickEffectiveness").comment("Effectiveness of quick gear repairs (crafting grid). Set to 0 to disable quick repairs.").defineInRange(0.35, 0.0, 1.0);
            this.upgradesInAnvilOnly = wrapper.builder("item.gear.upgrades.applyInAnvilOnly").comment("If true, upgrade parts may only be applied in an anvil.").define(false);
            wrapper.comment("salvager", "Settings for the salvager");
            this.salvagerMinLossRate = wrapper.builder("salvager.partLossRate.min").comment("Minimum rate of part loss when salvaging items. 0 = no loss, 1 = complete loss.", new String[]{"Rate depends on remaining durability."}).defineInRange(0.0, 0.0, 1.0);
            this.salvagerMaxLossRate = wrapper.builder("salvager.partLossRate.max").comment("Maximum rate of part loss when salvaging items. 0 = no loss, 1 = complete loss.", new String[]{"Rate depends on remaining durability."}).defineInRange(0.5, 0.0, 1.0);
        }

        public boolean isPlacerTool(ItemStack stack) {
            return General.isThingInList(stack.func_77973_b(), this.placerTools);
        }

        public boolean isPlaceableItem(ItemStack stack) {
            return General.isThingInList(stack.func_77973_b(), this.placeableItems);
        }

        public boolean isSinewAnimal(EntityLivingBase entity) {
            return General.isThingInList(entity.func_200600_R(), this.sinewAnimals);
        }

        private static boolean isThingInList(IForgeRegistryEntry<?> thing, ConfigValue<List<? extends String>> list) {
            ResourceLocation name = thing.getRegistryName();
            for (String str : (List)list.get()) {
                ResourceLocation fromList = ResourceLocation.func_208304_a((String)str);
                if (fromList == null || !fromList.equals((Object)name)) continue;
                return true;
            }
            return false;
        }
    }
}

