/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonObject;
import java.util.Collection;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.IUpgradePart;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.lib.collection.StackList;

public class UpgradeGear
implements IRecipe {
    public boolean func_77569_a(IInventory inv, World worldIn) {
        if (((Boolean)Config.GENERAL.upgradesInAnvilOnly.get()).booleanValue()) {
            return false;
        }
        StackList list = StackList.from((IInventory)inv);
        ItemStack gear = list.uniqueOfType(ICoreItem.class);
        ItemStack upgrade = list.firstMatch(stack -> {
            PartData part = PartData.fromStackFast(stack);
            return part != null && part.getPart() instanceof IUpgradePart;
        });
        return !gear.func_190926_b() && !upgrade.func_190926_b();
    }

    public ItemStack func_77572_b(IInventory inv) {
        StackList list = StackList.from((IInventory)inv);
        ItemStack gear = list.uniqueOfType(ICoreItem.class);
        if (gear.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        Collection upgrades = list.allMatches(stack -> {
            PartData part = PartData.fromStackFast(stack);
            return part != null && part.getPart() instanceof IUpgradePart;
        });
        ItemStack result = gear.func_77946_l();
        for (ItemStack upgrade : upgrades) {
            GearData.addUpgradePart(result, upgrade);
        }
        GearData.recalculateStats(null, result);
        return result;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean func_192399_d() {
        return true;
    }

    public ResourceLocation func_199560_c() {
        return Serializer.NAME;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Serializer.INSTANCE;
    }

    public static final class Serializer
    implements IRecipeSerializer<UpgradeGear> {
        public static final Serializer INSTANCE = new Serializer();
        private static final ResourceLocation NAME = new ResourceLocation("silentgear", "upgrade_gear");

        public UpgradeGear read(ResourceLocation recipeId, JsonObject json) {
            return new UpgradeGear();
        }

        public UpgradeGear read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new UpgradeGear();
        }

        public void write(PacketBuffer buffer, UpgradeGear recipe) {
        }

        public ResourceLocation getName() {
            return NAME;
        }
    }
}

