/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.entity.projectile;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceFluidMode;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;

public class SlingshotProjectile
extends Entity
implements IProjectile {
    private static final Predicate<Entity> ARROW_TARGETS = EntitySelectors.field_180132_d.and(EntitySelectors.field_94557_a.and(Entity::func_70067_L));
    private static final DataParameter<Byte> CRITICAL = EntityDataManager.func_187226_a(EntityArrow.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Optional<UUID>> field_212362_a = EntityDataManager.func_187226_a(SlingshotProjectile.class, (DataSerializer)DataSerializers.field_187203_m);
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    public UUID shootingEntity;
    private int ticksInAir;
    private double damage = 2.0;
    private int knockbackStrength;

    protected SlingshotProjectile(EntityType<?> type, World p_i48546_2_) {
        super(type, p_i48546_2_);
        this.func_70105_a(0.5f, 0.5f);
    }

    protected SlingshotProjectile(EntityType<?> p_i48547_1_, double p_i48547_2_, double p_i48547_4_, double p_i48547_6_, World p_i48547_8_) {
        this(p_i48547_1_, p_i48547_8_);
        this.func_70107_b(p_i48547_2_, p_i48547_4_, p_i48547_6_);
    }

    protected SlingshotProjectile(EntityType<?> p_i48548_1_, EntityLivingBase p_i48548_2_, World p_i48548_3_) {
        this(p_i48548_1_, p_i48548_2_.field_70165_t, p_i48548_2_.field_70163_u + (double)p_i48548_2_.func_70047_e() - (double)0.1f, p_i48548_2_.field_70161_v, p_i48548_3_);
        this.setShooter((Entity)p_i48548_2_);
    }

    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * SlingshotProjectile.func_184183_bd()) * d0;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(CRITICAL, (Object)0);
        this.field_70180_af.func_187214_a(field_212362_a, Optional.empty());
    }

    public void shoot(Entity shooter, float pitch, float yaw, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        this.field_70159_w += shooter.field_70159_w;
        this.field_70179_y += shooter.field_70179_y;
        if (!shooter.field_70122_E) {
            this.field_70181_x += shooter.field_70181_x;
        }
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.2957763671875);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    public void func_70071_h_() {
        Entity entity;
        VoxelShape voxelshape;
        BlockPos blockpos;
        IBlockState iblockstate;
        super.func_70071_h_();
        boolean flag = this.func_203047_q();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (!((iblockstate = this.field_70170_p.func_180495_p(blockpos = new BlockPos(this.xTile, this.yTile, this.zTile))).isAir((IBlockReader)this.field_70170_p, blockpos) || flag || (voxelshape = iblockstate.func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b())) {
            for (AxisAlignedBB axisalignedbb : voxelshape.func_197756_d()) {
                if (!axisalignedbb.func_186670_a(blockpos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) continue;
                this.func_70106_y();
                break;
            }
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        ++this.ticksInAir;
        Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_200259_a(vec3d, vec3d1, RayTraceFluidMode.NEVER, true, false);
        vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d1 = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        if ((entity = this.findEntityOnPath(vec3d, vec3d1)) != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null && raytraceresult.field_72308_g instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)raytraceresult.field_72308_g;
            Entity entity1 = this.getShooter();
            if (entity1 instanceof EntityPlayer && !((EntityPlayer)entity1).func_96122_a(entityplayer)) {
                raytraceresult = null;
            }
        }
        if (raytraceresult != null && !flag && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
            this.onHit(raytraceresult);
            this.field_70160_al = true;
        }
        if (this.getIsCritical()) {
            for (int j = 0; j < 4; ++j) {
                this.field_70170_p.func_195594_a((IParticleData)Particles.field_197614_g, this.field_70165_t + this.field_70159_w * (double)j / 4.0, this.field_70163_u + this.field_70181_x * (double)j / 4.0, this.field_70161_v + this.field_70179_y * (double)j / 4.0, -this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y);
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f3 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = flag ? (float)(MathHelper.func_181159_b((double)(-this.field_70159_w), (double)(-this.field_70179_y)) * 57.2957763671875) : (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f3) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float f4 = 0.99f;
        float f1 = 0.05f;
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float f2 = 0.25f;
                this.field_70170_p.func_195594_a((IParticleData)Particles.field_197612_e, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            f4 = this.getWaterDrag();
        }
        this.field_70159_w *= (double)f4;
        this.field_70181_x *= (double)f4;
        this.field_70179_y *= (double)f4;
        if (!this.func_189652_ae() && !flag) {
            this.field_70181_x -= (double)0.05f;
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
    }

    protected void onHit(RayTraceResult raytraceResultIn) {
        if (raytraceResultIn.field_72308_g != null) {
            this.onHitEntity(raytraceResultIn);
        } else {
            this.func_70106_y();
        }
    }

    protected void onHitEntity(RayTraceResult p_203046_1_) {
        Entity entity1;
        Entity entity = p_203046_1_.field_72308_g;
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        int i = MathHelper.func_76143_f((double)((double)f * this.damage));
        if (this.getIsCritical()) {
            i += this.field_70146_Z.nextInt(i / 2 + 2);
        }
        DamageSource damagesource = new EntityDamageSourceIndirect("slingshot", (Entity)this, (Entity)((entity1 = this.getShooter()) == null ? this : entity1)).func_76349_b();
        if (this.func_70027_ad() && !(entity instanceof EntityEnderman)) {
            entity.func_70015_d(5);
        }
        if (entity.func_70097_a(damagesource, (float)i)) {
            if (entity instanceof EntityLivingBase) {
                float f1;
                EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                if (!this.field_70170_p.field_72995_K) {
                    entitylivingbase.func_85034_r(entitylivingbase.func_85035_bI() + 1);
                }
                if (this.knockbackStrength > 0 && (f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                    entitylivingbase.func_70024_g(this.field_70159_w * (double)this.knockbackStrength * (double)0.6f / (double)f1, 0.1, this.field_70179_y * (double)this.knockbackStrength * (double)0.6f / (double)f1);
                }
                if (entity1 instanceof EntityLivingBase) {
                    EnchantmentHelper.func_151384_a((EntityLivingBase)entitylivingbase, (Entity)entity1);
                    EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)entity1), (Entity)entitylivingbase);
                }
                this.arrowHit(entitylivingbase);
                if (entity1 != null && entitylivingbase != entity1 && entitylivingbase instanceof EntityPlayer && entity1 instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)entity1).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(6, 0.0f));
                }
            }
            this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            if (!(entity instanceof EntityEnderman)) {
                this.func_70106_y();
            }
        } else {
            this.field_70159_w *= (double)-0.1f;
            this.field_70181_x *= (double)-0.1f;
            this.field_70179_y *= (double)-0.1f;
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
            this.ticksInAir = 0;
            if (!this.field_70170_p.field_72995_K && this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y < (double)0.001f) {
                this.func_70106_y();
            }
        }
    }

    protected SoundEvent getHitGroundSound() {
        return SoundEvents.field_187731_t;
    }

    protected void arrowHit(EntityLivingBase living) {
    }

    @Nullable
    protected Entity findEntityOnPath(Vec3d start, Vec3d end) {
        Entity entity = null;
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0), ARROW_TARGETS);
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult;
            Entity entity1 = (Entity)list.get(i);
            if (entity1 == this.getShooter() && this.ticksInAir < 5 || (raytraceresult = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(start, end)) == null || !((d1 = start.func_72436_e(raytraceresult.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity;
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("xTile", this.xTile);
        compound.func_74768_a("yTile", this.yTile);
        compound.func_74768_a("zTile", this.zTile);
        compound.func_74780_a("damage", this.damage);
        compound.func_74757_a("crit", this.getIsCritical());
        if (this.shootingEntity != null) {
            compound.func_186854_a("OwnerUUID", this.shootingEntity);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.xTile = compound.func_74762_e("xTile");
        this.yTile = compound.func_74762_e("yTile");
        this.zTile = compound.func_74762_e("zTile");
        if (compound.func_150297_b("damage", 99)) {
            this.damage = compound.func_74769_h("damage");
        }
        this.setIsCritical(compound.func_74767_n("crit"));
        if (compound.func_186855_b("OwnerUUID")) {
            this.shootingEntity = compound.func_186857_a("OwnerUUID");
        }
    }

    public void setShooter(@Nullable Entity p_212361_1_) {
        this.shootingEntity = p_212361_1_ == null ? null : p_212361_1_.func_110124_au();
    }

    @Nullable
    public Entity getShooter() {
        return this.shootingEntity != null && this.field_70170_p instanceof WorldServer ? ((WorldServer)this.field_70170_p).func_175733_a(this.shootingEntity) : null;
    }

    protected ItemStack getArrowStack() {
        return ItemStack.field_190927_a;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void setDamage(double damageIn) {
        this.damage = damageIn;
    }

    public double getDamage() {
        return this.damage;
    }

    public void setKnockbackStrength(int knockbackStrengthIn) {
        this.knockbackStrength = knockbackStrengthIn;
    }

    public boolean func_70075_an() {
        return false;
    }

    public float func_70047_e() {
        return 0.0f;
    }

    public void setIsCritical(boolean critical) {
        this.func_203049_a(1, critical);
    }

    private void func_203049_a(int p_203049_1_, boolean p_203049_2_) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CRITICAL);
        if (p_203049_2_) {
            this.field_70180_af.func_187227_b(CRITICAL, (Object)((byte)(b0 | p_203049_1_)));
        } else {
            this.field_70180_af.func_187227_b(CRITICAL, (Object)((byte)(b0 & ~p_203049_1_)));
        }
    }

    public boolean getIsCritical() {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CRITICAL);
        return (b0 & 1) != 0;
    }

    public void setEnchantmentEffectsFromEntity(EntityLivingBase p_190547_1_, float p_190547_2_) {
        int i = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185309_u, (EntityLivingBase)p_190547_1_);
        int j = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185310_v, (EntityLivingBase)p_190547_1_);
        this.setDamage((double)(p_190547_2_ * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
        if (i > 0) {
            this.setDamage(this.getDamage() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            this.setKnockbackStrength(j);
        }
        if (EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185311_w, (EntityLivingBase)p_190547_1_) > 0) {
            this.func_70015_d(100);
        }
    }

    protected float getWaterDrag() {
        return 0.6f;
    }

    public void func_203045_n(boolean p_203045_1_) {
        this.field_70145_X = p_203045_1_;
        this.func_203049_a(2, p_203045_1_);
    }

    public boolean func_203047_q() {
        if (!this.field_70170_p.field_72995_K) {
            return this.field_70145_X;
        }
        return ((Byte)this.field_70180_af.func_187225_a(CRITICAL) & 2) != 0;
    }
}

