/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.event;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumLightType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.traits.TraitConst;
import net.silentchaos512.gear.traits.TraitManager;
import net.silentchaos512.gear.util.TraitHelper;

@Mod.EventBusSubscriber
public final class GearEvents {
    private static final Set<UUID> entityAttackedThisTick = new HashSet<UUID>();

    private GearEvents() {
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent events) {
        entityAttackedThisTick.clear();
    }

    @SubscribeEvent
    public static void onAttackEntity(LivingAttackEvent event) {
        EntityLivingBase attacked = event.getEntityLiving();
        if (attacked == null || entityAttackedThisTick.contains(attacked.func_110124_au())) {
            return;
        }
        DamageSource source = event.getSource();
        if (source == null) {
            return;
        }
        Entity attacker = source.func_76346_g();
        if (!(attacker instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)attacker;
        ItemStack weapon = player.func_184614_ca();
        if (!(weapon.func_77973_b() instanceof ICoreTool)) {
            return;
        }
        float baseDamage = event.getAmount();
        float newDamage = TraitHelper.activateTraits(weapon, baseDamage, (trait, level, value) -> trait.onAttackEntity(new TraitActionContext(player, level, weapon), attacked, baseDamage));
        if (Math.abs(newDamage - baseDamage) > 1.0E-4f) {
            event.setCanceled(true);
            entityAttackedThisTick.add(attacked.func_110124_au());
            attacked.func_70097_a(source, newDamage);
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack tool = player.func_184614_ca();
        if (tool.func_77973_b() instanceof ICoreItem) {
            boolean canHarvest;
            IBlockState state = event.getState();
            ToolType toolClass = state.func_177230_c().getHarvestTool(state);
            int blockLevel = state.func_177230_c().getHarvestLevel(state);
            int toolLevel = tool.func_77973_b().getHarvestLevel(tool, toolClass, player, state);
            boolean bl = canHarvest = toolLevel >= blockLevel;
            if (canHarvest) {
                ITrait lustrous = TraitManager.get(TraitConst.LUSTROUS);
                int level = TraitHelper.getTraitLevel(tool, lustrous);
                int light = GearEvents.getLightForLustrousTrait(player.field_70170_p, player.func_180425_c());
                event.setNewSpeed(event.getOriginalSpeed() + (float)GearEvents.getLustrousSpeedBonus(level, light));
            }
        }
    }

    public static int getLightForLustrousTrait(World world, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        boolean hasSkylight = world.field_73011_w.func_191066_m();
        int blockLight = chunk.func_201587_a(EnumLightType.BLOCK, pos, hasSkylight);
        int skyLight = chunk.func_201587_a(EnumLightType.SKY, pos, hasSkylight);
        return Math.max(skyLight, blockLight * 3 / 4);
    }

    public static int getLustrousSpeedBonus(int level, int light) {
        return 4 * level * light / 15;
    }

    @SubscribeEvent
    public static void onBlockDrops(BlockEvent.HarvestDropsEvent event) {
        if (event.isSilkTouching() || event.getHarvester() == null) {
            return;
        }
        ItemStack tool = event.getHarvester().func_184614_ca();
        if (tool.func_190926_b() || !(tool.func_77973_b() instanceof ICoreTool)) {
            return;
        }
        int magmaticLevel = TraitHelper.getTraitLevel(tool, TraitConst.MAGMATIC);
        if (magmaticLevel == 0) {
            return;
        }
        for (int i = 0; i < event.getDrops().size(); ++i) {
            ItemStack itemStack = (ItemStack)event.getDrops().get(i);
        }
    }

    @SubscribeEvent
    public static void onXpDrop(LivingExperienceDropEvent event) {
        if (event.getAttackingPlayer() == null) {
            return;
        }
        ItemStack tool = event.getAttackingPlayer().func_184614_ca();
        if (tool.func_190926_b() || !(tool.func_77973_b() instanceof ICoreTool)) {
            return;
        }
        int ancientLevel = TraitHelper.getTraitLevel(tool, TraitConst.ANCIENT);
        if (ancientLevel == 0) {
            return;
        }
        int bonusXp = (int)((float)event.getOriginalExperience() * 0.25f * (float)ancientLevel);
        event.setDroppedExperience(event.getDroppedExperience() + bonusXp);
    }

    @SubscribeEvent
    public static void onBlockXpDrop(BlockEvent.BreakEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        ItemStack tool = event.getPlayer().func_184614_ca();
        if (tool.func_190926_b() || !(tool.func_77973_b() instanceof ICoreTool)) {
            return;
        }
        int ancientLevel = TraitHelper.getTraitLevel(tool, TraitConst.ANCIENT);
        if (ancientLevel == 0) {
            return;
        }
        int bonusXp = (int)((float)event.getExpToDrop() * 0.25f * (float)ancientLevel);
        event.setExpToDrop(event.getExpToDrop() + bonusXp);
    }
}

