/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.event;

import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.IUpgradePart;
import net.silentchaos512.gear.api.stats.CommonItemStats;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.RepairContext;
import net.silentchaos512.gear.parts.type.PartMain;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.lib.advancements.LibTriggers;

@Mod.EventBusSubscriber(modid="silentgear")
public final class RepairHandler {
    private static final ResourceLocation APPLY_TIP_UPGRADE = SilentGear.getId("apply_tip_upgrade");
    private static final ResourceLocation MAX_DURABILITY = SilentGear.getId("max_durability");
    private static final ResourceLocation REPAIR_FROM_BROKEN = SilentGear.getId("repair_from_broken");

    private RepairHandler() {
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        PartData part;
        if (event.getLeft().func_77973_b() instanceof ICoreItem && (part = PartData.from(event.getRight())) != null) {
            if (part.getPart() instanceof IUpgradePart) {
                RepairHandler.handleUpgradeApplication(event, part);
            } else if (part.getPart() instanceof PartMain) {
                RepairHandler.handleGearRepair(event, part);
            }
        }
    }

    private static void handleUpgradeApplication(AnvilUpdateEvent event, PartData part) {
        ItemStack result = event.getLeft().func_77946_l();
        GearData.addUpgradePart(result, part);
        GearData.recalculateStats(null, result);
        event.setOutput(result);
        event.setCost(3);
    }

    private static void handleGearRepair(AnvilUpdateEvent event, PartData part) {
        ItemStack result = event.getLeft().func_77946_l();
        float amount = part.getRepairAmount(result, RepairContext.Type.ANVIL);
        int materialCount = 1;
        for (float repaired = amount *= GearData.getStat(result, CommonItemStats.REPAIR_EFFICIENCY); materialCount < event.getRight().func_190916_E() && repaired < (float)result.func_77952_i(); ++materialCount, repaired += amount) {
        }
        if (amount > 0.0f) {
            result.func_96631_a(-Math.round(amount * (float)materialCount), SilentGear.random, null);
            GearData.recalculateStats(null, result);
            event.setOutput(result);
            event.setCost(materialCount);
            event.setMaterialCost(materialCount);
        }
    }

    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        ItemStack result = event.getCrafting();
        if (!(result.func_77973_b() instanceof ICoreItem)) {
            return;
        }
        if (event.getPlayer() instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.getPlayer();
            int brokenCount = GearData.getBrokenCount(result);
            int repairCount = GearData.getRepairCount(result);
            if (brokenCount > 0 && repairCount > 0) {
                LibTriggers.GENERIC_INT.trigger(player, REPAIR_FROM_BROKEN, brokenCount);
            }
            LibTriggers.GENERIC_INT.trigger(player, MAX_DURABILITY, result.func_77958_k());
            if (!GearData.getConstructionParts(result).getTips().isEmpty()) {
                LibTriggers.GENERIC_INT.trigger(player, APPLY_TIP_UPGRADE, 1);
            }
        }
    }
}

