/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.event;

import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.network.NetworkDirection;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.network.Network;
import net.silentchaos512.gear.network.SyncGearPartsPacket;
import net.silentchaos512.gear.network.SyncTraitsPacket;
import net.silentchaos512.gear.parts.PartManager;
import net.silentchaos512.gear.traits.TraitManager;

@Mod.EventBusSubscriber(modid="silentgear")
public final class ServerEvents {
    private ServerEvents() {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerJoinServer(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.getPlayer();
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        ServerEvents.sendTraitsToClient(playerMP);
        ServerEvents.sendPartsToClient(playerMP);
    }

    private static void sendTraitsToClient(EntityPlayerMP playerMP) {
        Collection<ITrait> traits = TraitManager.getValues();
        SilentGear.LOGGER.info("Sending {} traits to {}", (Object)traits.size(), (Object)playerMP.func_195047_I_());
        SyncTraitsPacket msg = new SyncTraitsPacket(traits);
        Network.channel.sendTo((Object)msg, playerMP.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }

    private static void sendPartsToClient(EntityPlayerMP playerMP) {
        Collection<IGearPart> parts = PartManager.getValues();
        SilentGear.LOGGER.info("Sending {} gear parts to {}", (Object)parts.size(), (Object)playerMP.func_195047_I_());
        SyncGearPartsPacket msg = new SyncGearPartsPacket(parts);
        Network.channel.sendTo((Object)msg, playerMP.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }
}

