/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.event;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.util.GearHelper;

@Mod.EventBusSubscriber(modid="silentgear")
public final class ToolBlockPlaceHandler {
    private ToolBlockPlaceHandler() {
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        if (stack.func_190926_b() || !ToolBlockPlaceHandler.canToolPlaceBlock(stack)) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (!player.func_70093_af()) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        EnumFacing side = event.getFace();
        if (side == null) {
            return;
        }
        ItemStack stackOffHand = player.func_184592_cb();
        Vec3d hit = event.getHitVec();
        ItemUseContext context = new ItemUseContext(player, stackOffHand, pos, side, (float)hit.field_72450_a, (float)hit.field_72448_b, (float)hit.field_72449_c);
        if (!stackOffHand.func_190926_b() && stackOffHand.func_77973_b() instanceof ItemBlock && !ToolBlockPlaceHandler.canPlaceBlockAt(context)) {
            return;
        }
        int toolSlot = player.field_71071_by.field_70461_c;
        int itemSlot = toolSlot + 1;
        ItemStack nextStack = ItemStack.field_190927_a;
        ItemStack lastStack = player.field_71071_by.func_70301_a(8);
        if (toolSlot < 8 && ToolBlockPlaceHandler.itemNotPlaceable(nextStack = player.field_71071_by.func_70301_a(itemSlot))) {
            nextStack = lastStack;
            itemSlot = 8;
            if (ToolBlockPlaceHandler.itemNotPlaceable(nextStack)) {
                return;
            }
        }
        Item item = nextStack.func_77973_b();
        BlockPos targetPos = pos.func_177972_a(side);
        if (item instanceof ItemBlock) {
            int px = targetPos.func_177958_n();
            int py = targetPos.func_177956_o();
            int pz = targetPos.func_177952_p();
            AxisAlignedBB blockBounds = new AxisAlignedBB((double)px, (double)py, (double)pz, (double)(px + 1), (double)(py + 1), (double)(pz + 1));
            AxisAlignedBB playerBounds = player.func_174813_aQ();
            ItemBlock itemBlock = (ItemBlock)item;
            Block block = itemBlock.func_179223_d();
            IBlockState state = block.func_176223_P();
            if (state.func_185904_a().func_76230_c() && playerBounds.func_72326_a(blockBounds)) {
                return;
            }
        }
        int prevSize = nextStack.func_190916_E();
        ItemUseContext context1 = new ItemUseContext(player, nextStack, pos, side, (float)hit.field_72450_a, (float)hit.field_72448_b, (float)hit.field_72449_c);
        EnumActionResult result = ToolBlockPlaceHandler.useItemAsPlayer(context1);
        if (result == EnumActionResult.SUCCESS) {
            player.func_184609_a(EnumHand.MAIN_HAND);
        }
        if (player.field_71075_bZ.field_75098_d) {
            nextStack.func_190920_e(prevSize);
        }
        if (nextStack.func_190926_b()) {
            player.field_71071_by.func_70299_a(itemSlot, ItemStack.field_190927_a);
        }
    }

    private static EnumActionResult useItemAsPlayer(ItemUseContext context) {
        return context.func_195996_i().func_196084_a(context);
    }

    private static boolean canToolPlaceBlock(ItemStack stack) {
        if (stack.func_77973_b() instanceof ICoreItem && GearHelper.isBroken(stack)) {
            return false;
        }
        return Config.GENERAL.isPlacerTool(stack);
    }

    private static boolean canPlaceBlockAt(ItemUseContext context) {
        EntityPlayer player = context.func_195999_j();
        if (player == null) {
            return false;
        }
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        EnumFacing side = context.func_196000_l();
        ItemStack usedStack = context.func_195996_i();
        if (usedStack.func_77973_b() instanceof ItemBlock) {
            Block block = ((ItemBlock)usedStack.func_77973_b()).func_179223_d();
            BlockItemUseContext blockContext = new BlockItemUseContext(context);
            if (block.func_176223_P().func_196953_a(blockContext)) {
                pos = pos.func_177972_a(side);
            }
        }
        return player.func_175151_a(pos, side, usedStack);
    }

    private static boolean itemNotPlaceable(ItemStack stack) {
        return stack.func_190926_b() || stack.func_77942_o() && stack.func_196082_o().func_74764_b("NoPlacing") || !(stack.func_77973_b() instanceof ItemBlock) && !Config.GENERAL.isPlaceableItem(stack);
    }
}

