/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemWallOrFloor;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.block.CrimsonIronOre;
import net.silentchaos512.gear.block.FlaxPlant;
import net.silentchaos512.gear.block.Flower;
import net.silentchaos512.gear.block.NetherwoodLeaves;
import net.silentchaos512.gear.block.NetherwoodLog;
import net.silentchaos512.gear.block.NetherwoodPlanks;
import net.silentchaos512.gear.block.NetherwoodSapling;
import net.silentchaos512.gear.block.PhantomLight;
import net.silentchaos512.gear.block.StoneTorch;
import net.silentchaos512.gear.block.StoneTorchWall;
import net.silentchaos512.gear.block.analyzer.BlockPartAnalyzer;
import net.silentchaos512.gear.block.craftingstation.BlockCraftingStation;
import net.silentchaos512.gear.block.salvager.BlockSalvager;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.lib.block.IBlockProvider;
import net.silentchaos512.utils.Lazy;

public enum ModBlocks implements IBlockProvider,
IStringSerializable
{
    CRAFTING_STATION(BlockCraftingStation::new),
    PART_ANALYZER(BlockPartAnalyzer::new),
    SALVAGER(BlockSalvager::new),
    FLOWER(Flower::new),
    FLAX_PLANT(() -> new FlaxPlant(false), () -> null),
    WILD_FLAX_PLANT(() -> new FlaxPlant(true), () -> null),
    STONE_TORCH(StoneTorch::new, ModBlocks::getStoneTorchItem),
    WALL_STONE_TORCH(StoneTorchWall::new, () -> null),
    NETHERWOOD_LOG(NetherwoodLog::new),
    NETHERWOOD_PLANKS(NetherwoodPlanks::new),
    NETHERWOOD_LEAVES(NetherwoodLeaves::new),
    NETHERWOOD_SAPLING(NetherwoodSapling::new),
    CRIMSON_IRON_ORE(CrimsonIronOre::new),
    POTTED_FLOWER(() -> ModBlocks.makePottedPlant(FLOWER), () -> null),
    POTTED_NETHERWOOD_SAPLING(() -> ModBlocks.makePottedPlant(NETHERWOOD_SAPLING), () -> null),
    PHANTOM_LIGHT(PhantomLight::new);

    private final Lazy<Block> block;
    private final Lazy<ItemBlock> item;

    private ModBlocks(Supplier<Block> blockSupplier) {
        this.block = Lazy.of(blockSupplier);
        this.item = Lazy.of(() -> new ItemBlock(this.asBlock(), new Item.Properties().func_200916_a(SilentGear.ITEM_GROUP)));
    }

    private ModBlocks(Supplier<Block> blockSupplier, Supplier<ItemBlock> itemBlockSupplier) {
        this.block = Lazy.of(blockSupplier);
        this.item = Lazy.of(itemBlockSupplier);
    }

    public static void registerAll(RegistryEvent.Register<Block> event) {
        if (!event.getName().equals((Object)ForgeRegistries.BLOCKS.getRegistryName())) {
            return;
        }
        for (ModBlocks block : ModBlocks.values()) {
            ModBlocks.register(block.func_176610_l(), block.asBlock(), (ItemBlock)block.item.get());
        }
    }

    private static void register(String name, Block block, @Nullable ItemBlock item) {
        ResourceLocation registryName = new ResourceLocation("silentgear", name);
        block.setRegistryName(registryName);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        if (item != null) {
            ModItems.blocksToRegister.put(name, item);
        }
    }

    private static ItemBlock getStoneTorchItem() {
        return new ItemWallOrFloor(STONE_TORCH.asBlock(), WALL_STONE_TORCH.asBlock(), new Item.Properties());
    }

    private static BlockFlowerPot makePottedPlant(IBlockProvider flower) {
        return new BlockFlowerPot(flower.asBlock(), Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200943_b(0.0f));
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public Block asBlock() {
        return (Block)this.block.get();
    }

    public Item func_199767_j() {
        return this.asBlock().func_199767_j();
    }
}

