/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.api.item.ICoreArmor;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.item.BlueprintPackage;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.item.Flaxseeds;
import net.silentchaos512.gear.item.NetherBanana;
import net.silentchaos512.gear.item.blueprint.GearBlueprint;
import net.silentchaos512.gear.item.blueprint.PartBlueprint;
import net.silentchaos512.gear.item.blueprint.book.BlueprintBook;
import net.silentchaos512.gear.item.gear.CoreArmor;
import net.silentchaos512.gear.item.gear.CoreAxe;
import net.silentchaos512.gear.item.gear.CoreBow;
import net.silentchaos512.gear.item.gear.CoreDagger;
import net.silentchaos512.gear.item.gear.CoreExcavator;
import net.silentchaos512.gear.item.gear.CoreHammer;
import net.silentchaos512.gear.item.gear.CoreKatana;
import net.silentchaos512.gear.item.gear.CoreMachete;
import net.silentchaos512.gear.item.gear.CoreMattock;
import net.silentchaos512.gear.item.gear.CorePickaxe;
import net.silentchaos512.gear.item.gear.CoreShovel;
import net.silentchaos512.gear.item.gear.CoreSickle;
import net.silentchaos512.gear.item.gear.CoreSlingshot;
import net.silentchaos512.gear.item.gear.CoreSpear;
import net.silentchaos512.gear.item.gear.CoreSword;

public final class ModItems {
    public static final Map<String, ICoreTool> toolClasses = new LinkedHashMap<String, ICoreTool>();
    public static final Map<String, ICoreArmor> armorClasses = new LinkedHashMap<String, ICoreArmor>();
    public static final Map<String, ICoreItem> gearClasses = new LinkedHashMap<String, ICoreItem>();
    public static final List<GearBlueprint> blueprints = new ArrayList<GearBlueprint>();
    static final Map<String, ItemBlock> blocksToRegister = new LinkedHashMap<String, ItemBlock>();
    public static BlueprintPackage blueprintPackage;
    public static BlueprintBook blueprintBook;
    public static Flaxseeds flaxseeds;
    public static NetherBanana netherBanana;
    public static CoreSword sword;
    public static CoreDagger dagger;
    public static CoreKatana katana;
    public static CoreMachete machete;
    public static CoreSpear spear;
    public static CorePickaxe pickaxe;
    public static CoreShovel shovel;
    public static CoreAxe axe;
    public static CoreHammer hammer;
    public static CoreExcavator excavator;
    public static CoreMattock mattock;
    public static CoreSickle sickle;
    public static CoreBow bow;
    public static CoreSlingshot slingshot;
    public static CoreArmor helmet;
    public static CoreArmor chestplate;
    public static CoreArmor leggings;
    public static CoreArmor boots;

    private ModItems() {
    }

    public static void registerAll(RegistryEvent.Register<Item> event) {
        if (!event.getName().equals((Object)ForgeRegistries.ITEMS.getRegistryName())) {
            return;
        }
        blocksToRegister.forEach(ModItems::register);
        ModItems.initializeGear();
        blueprintPackage = ModItems.register("blueprint_package", new BlueprintPackage(new ResourceLocation("silentgear", "starter_blueprints")));
        ModItems.registerBlueprints("blueprint", false);
        ModItems.registerBlueprints("template", true);
        blueprintBook = ModItems.register("blueprint_book", new BlueprintBook());
        for (CraftingItems item2 : CraftingItems.values()) {
            ModItems.register(item2.func_176610_l(), item2.func_199767_j());
        }
        flaxseeds = ModItems.register("flaxseeds", new Flaxseeds());
        netherBanana = ModItems.register("nether_banana", new NetherBanana());
        toolClasses.forEach((key, item) -> ModItems.register(key, item.func_199767_j()));
        armorClasses.forEach((key, item) -> ModItems.register(key, item.func_199767_j()));
    }

    private static void initializeGear() {
        sword = new CoreSword();
        dagger = new CoreDagger();
        katana = new CoreKatana();
        machete = new CoreMachete();
        spear = new CoreSpear();
        pickaxe = new CorePickaxe();
        shovel = new CoreShovel();
        axe = new CoreAxe();
        hammer = new CoreHammer();
        excavator = new CoreExcavator();
        mattock = new CoreMattock();
        sickle = new CoreSickle();
        bow = new CoreBow();
        slingshot = new CoreSlingshot();
        helmet = new CoreArmor(EntityEquipmentSlot.HEAD, "helmet");
        chestplate = new CoreArmor(EntityEquipmentSlot.CHEST, "chestplate");
        leggings = new CoreArmor(EntityEquipmentSlot.LEGS, "leggings");
        boots = new CoreArmor(EntityEquipmentSlot.FEET, "boots");
        toolClasses.put("sword", sword);
        toolClasses.put("dagger", dagger);
        toolClasses.put("katana", katana);
        toolClasses.put("machete", machete);
        toolClasses.put("spear", spear);
        toolClasses.put("pickaxe", pickaxe);
        toolClasses.put("shovel", shovel);
        toolClasses.put("axe", axe);
        toolClasses.put("hammer", hammer);
        toolClasses.put("excavator", excavator);
        toolClasses.put("mattock", mattock);
        toolClasses.put("sickle", sickle);
        toolClasses.put("bow", bow);
        armorClasses.put("helmet", helmet);
        armorClasses.put("chestplate", chestplate);
        armorClasses.put("leggings", leggings);
        armorClasses.put("boots", boots);
        gearClasses.putAll(toolClasses);
        gearClasses.putAll(armorClasses);
    }

    private static <T extends Item> T register(String name, T item) {
        ResourceLocation id = new ResourceLocation("silentgear", name);
        item.setRegistryName(id);
        ForgeRegistries.ITEMS.register(item);
        return item;
    }

    private static void registerBlueprints(String name, boolean singleUse) {
        gearClasses.forEach((key, item) -> {
            GearBlueprint blueprint = new GearBlueprint(singleUse, (ICoreItem)item);
            blueprints.add(blueprint);
            ModItems.register(name + "_" + key, blueprint);
        });
        ModItems.register(name + "_rod", new PartBlueprint(singleUse, PartType.ROD));
        ModItems.register(name + "_bowstring", new PartBlueprint(singleUse, PartType.BOWSTRING));
    }
}

