/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.LazyLoadBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.block.analyzer.TilePartAnalyzer;
import net.silentchaos512.gear.block.craftingstation.TileCraftingStation;
import net.silentchaos512.gear.block.salvager.TileSalvager;

public enum ModTileEntities {
    CRAFTING_STATION(TileCraftingStation::new),
    PART_ANALYZER(TilePartAnalyzer::new),
    SALVAGER(TileSalvager::new);

    private final LazyLoadBase<TileEntityType<?>> type = new LazyLoadBase(() -> TileEntityType.Builder.func_200963_a((Supplier)tileEntitySupplier).func_206865_a(null));

    private ModTileEntities(Supplier<TileEntity> tileEntitySupplier) {
    }

    public TileEntityType<?> type() {
        return (TileEntityType)this.type.func_179281_c();
    }

    public static void registerAll(RegistryEvent.Register<TileEntityType<?>> event) {
        if (!event.getName().equals((Object)ForgeRegistries.TILE_ENTITIES.getRegistryName())) {
            return;
        }
        for (ModTileEntities tileEnum : ModTileEntities.values()) {
            ModTileEntities.register(tileEnum.name().toLowerCase(Locale.ROOT), tileEnum.type());
        }
    }

    private static <T extends TileEntity> void register(String name, TileEntityType<T> type) {
        ResourceLocation id = new ResourceLocation("silentgear", name);
        type.setRegistryName(id);
        ForgeRegistries.TILE_ENTITIES.register(type);
    }
}

