/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.parts.type.PartUpgrade;
import net.silentchaos512.lib.item.IEnumItems;

public enum MiscUpgrades implements IEnumItems<MiscUpgrades, Item>
{
    SPOON(MiscUpgrades::matchPickaxe),
    RED_CARD(MiscUpgrades::matchAny);

    private final Item item = new Item();
    private final PartUpgrade part;

    private MiscUpgrades(final Predicate<ICoreItem> canApplyTo) {
        ResourceLocation partName = new ResourceLocation("silentgear", "misc_" + this.name().toLowerCase(Locale.ROOT));
        this.part = new PartUpgrade(partName){

            @Override
            public PartType getType() {
                return PartType.MISC_UPGRADE;
            }

            @Override
            public boolean isValidFor(@Nonnull ICoreItem gearItem) {
                return canApplyTo.test(gearItem);
            }
        };
    }

    private static boolean matchPickaxe(ICoreItem item) {
        return item == ModItems.pickaxe;
    }

    private static boolean matchAny(ICoreItem item) {
        return item != null;
    }

    @Nonnull
    public MiscUpgrades getEnum() {
        return this;
    }

    @Nonnull
    public Item getItem() {
        return this.item;
    }

    @Nonnull
    public PartUpgrade getPart() {
        return this.part;
    }

    @Nonnull
    public String func_176610_l() {
        return this.getEnum().name().toLowerCase(Locale.ROOT) + "_upgrade";
    }

    public static class Item
    extends net.minecraft.item.Item {
        Item() {
            super(new Item.Properties().func_200916_a(SilentGear.ITEM_GROUP));
        }

        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
            tooltip.add(new TextComponentTranslation(this.func_77658_a() + ".desc", new Object[0]).func_211708_a(TextFormatting.ITALIC));
        }
    }
}

