/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.blueprint;

import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.item.blueprint.BlueprintType;
import net.silentchaos512.gear.item.blueprint.IBlueprint;

public abstract class AbstractBlueprint
extends Item
implements IBlueprint {
    final boolean singleUse;

    AbstractBlueprint(Item.Properties properties, boolean singleUse) {
        super(properties);
        this.singleUse = singleUse;
    }

    protected abstract ITextComponent getCraftedName(ItemStack var1);

    public ItemStack getContainerItem(ItemStack itemStack) {
        return itemStack.func_77946_l();
    }

    public boolean hasContainerItem(ItemStack stack) {
        return !this.isSingleUse(stack);
    }

    @Override
    public boolean isSingleUse(ItemStack blueprint) {
        return this.singleUse;
    }

    protected boolean isDisabled() {
        BlueprintType config = (BlueprintType)Config.GENERAL.blueprintTypes.get();
        return this.singleUse && !config.allowTemplate() || !this.singleUse && !config.allowBlueprint();
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.isDisabled()) {
            super.func_150895_a(group, items);
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        String key = "item.silentgear." + (this.singleUse ? "template" : "blueprint");
        return new TextComponentTranslation(key, new Object[]{this.getCraftedName(stack)});
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.isSingleUse(stack) ? EnumRarity.COMMON : EnumRarity.UNCOMMON;
    }
}

