/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.blueprint.book;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.client.gui.GuiHandlerSilentGear;
import net.silentchaos512.gear.item.blueprint.IBlueprint;
import net.silentchaos512.utils.Color;

public class BlueprintBook
extends Item
implements IBlueprint {
    public static final int INVENTORY_SIZE = 27;
    private static final int DEFAULT_COLOR = 0xFFFFFF;
    private static final String NBT_ROOT = "SGear_BlueprintBook";
    private static final String NBT_COLOR = "Color";
    private static final String NBT_INVENTORY = "Inventory";
    private static final String NBT_SELECTED = "Selected";

    public BlueprintBook() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(SilentGear.ITEM_GROUP));
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return itemStack;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        int subtype = handIn == EnumHand.OFF_HAND ? 1 : 0;
        GuiHandlerSilentGear.GuiType.BLUEPRINT_BOOK.open(playerIn, worldIn, subtype);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)heldItem);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TextComponentTranslation("item.silentgear.blueprint_book.desc", new Object[0]));
        String colorStr = Color.format((int)BlueprintBook.getCoverColor(stack));
        tooltip.add((ITextComponent)new TextComponentTranslation("item.silentgear.blueprint_book.color", new Object[]{colorStr}));
        tooltip.add((ITextComponent)new TextComponentTranslation("item.silentgear.blueprint_book.selected", new Object[]{"not implemented"}));
    }

    @Nullable
    static IItemHandler getInventory(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        NBTTagCompound tags = BlueprintBook.getTags(stack);
        if (!tags.func_74764_b(NBT_INVENTORY)) {
            tags.func_74782_a(NBT_INVENTORY, (INBTBase)new NBTTagList());
        }
        ItemStackHandler stackHandler = new ItemStackHandler(27);
        NBTTagList tagList = tags.func_150295_c(NBT_INVENTORY, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            stackHandler.setStackInSlot(i, ItemStack.func_199557_a((NBTTagCompound)tagList.func_150305_b(i)));
        }
        return stackHandler;
    }

    static void updateInventory(ItemStack stack, @Nullable IItemHandler itemHandler, EntityPlayer playerIn) {
        if (itemHandler == null) {
            return;
        }
        NBTTagCompound tags = BlueprintBook.getTags(stack);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack itemStack = itemHandler.getStackInSlot(i);
            tagList.add((INBTBase)itemStack.serializeNBT());
        }
        tags.func_74782_a(NBT_INVENTORY, (INBTBase)tagList);
    }

    private static NBTTagCompound getTags(ItemStack stack) {
        return stack.func_190925_c(NBT_ROOT);
    }

    public int getColor(ItemStack stack, int tintIndex) {
        return tintIndex == 0 ? BlueprintBook.getCoverColor(stack) : 0xFFFFFF;
    }

    private static int getCoverColor(ItemStack stack) {
        NBTTagCompound tags = BlueprintBook.getTags(stack);
        return tags.func_74764_b(NBT_COLOR) ? tags.func_74762_e(NBT_COLOR) : 0xFFFFFF;
    }
}

