/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.blueprint.book;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.items.IItemHandler;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.item.blueprint.book.BlueprintBook;
import net.silentchaos512.gear.item.blueprint.book.SlotBlueprint;

public class ContainerBlueprintBook
extends Container {
    @Nonnull
    private final ItemStack book;
    @Nullable
    private final IItemHandler itemHandler;
    private int blocked = -1;

    public ContainerBlueprintBook(ItemStack book, InventoryPlayer inventoryPlayer, EnumHand hand) {
        this.book = book;
        this.itemHandler = BlueprintBook.getInventory(book);
        this.setupSlots(inventoryPlayer, hand);
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    private void setupSlots(InventoryPlayer inventoryPlayer, EnumHand hand) {
        this.setupBookSlots();
        this.setupPlayerSlots(inventoryPlayer);
    }

    private void setupBookSlots() {
        if (this.itemHandler == null) {
            SilentGear.LOGGER.error("Blueprint book has no inventory? ItemStack: {}", (Object)this.book);
            return;
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a((Slot)new SlotBlueprint(this.itemHandler, col + row * 9, 8 + col * 18, 18 + row * 18));
            }
        }
    }

    private void setupPlayerSlots(InventoryPlayer inventoryPlayer) {
        int numRows = 3;
        int hotbarYOffset = -18;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, x + y * 9 + 9, 8 + x * 18, 103 + y * 18 + -18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, x, 8 + x * 18, 143));
        }
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (slotId < 0 || slotId > this.field_75151_b.size()) {
            return super.func_184996_a(slotId, dragType, clickTypeIn, player);
        }
        Slot slot = (Slot)this.field_75151_b.get(slotId);
        if (!this.canTake(slotId, slot, dragType, player, clickTypeIn)) {
            return slot.func_75211_c();
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (!(this.book.func_77973_b() instanceof BlueprintBook)) {
            SilentGear.LOGGER.error("Item is not a blueprint book? ItemStack: {}", (Object)this.book, (Object)new IllegalStateException("ContainerBlueprintBook not constructed with BlueprintBook"));
            return;
        }
        BlueprintBook.updateInventory(this.book, this.itemHandler, playerIn);
    }

    private boolean canTake(int slotId, Slot slot, int dragType, EntityPlayer player, ClickType clickType) {
        if (slotId == this.blocked) {
            return false;
        }
        if (slotId < 27 && player.field_71071_by.func_70445_o().func_77973_b() instanceof BlueprintBook) {
            return false;
        }
        if (clickType == ClickType.SWAP) {
            int hotbarId = 54 + dragType;
            if (this.blocked == hotbarId) {
                return false;
            }
            Slot hotbarSlot = this.func_75139_a(hotbarId);
            boolean eitherIsBlueprintBook = slot.func_75211_c().func_77973_b() instanceof BlueprintBook || hotbarSlot.func_75211_c().func_77973_b() instanceof BlueprintBook;
            return slotId >= 27 || !eitherIsBlueprintBook;
        }
        return true;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        Slot slot = this.func_75139_a(slotIndex);
        if (!slot.func_82869_a(player)) {
            return slot.func_75211_c();
        }
        if (slotIndex == this.blocked || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = slot.func_75211_c();
        ItemStack newStack = stack.func_77946_l();
        if (slotIndex < 27) {
            if (!this.func_75135_a(stack, 27, this.field_75151_b.size(), true)) {
                return ItemStack.field_190927_a;
            }
            slot.func_75218_e();
        } else if (!this.func_75135_a(stack, 0, 27, false)) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        return slot.func_190901_a(player, newStack);
    }
}

