/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreArmor;
import net.silentchaos512.gear.api.parts.IPartDisplay;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.CommonItemStats;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartManager;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public class CoreArmor
extends ItemArmor
implements ICoreArmor {
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private static final float[] ABSORPTION_RATIO_BY_SLOT = new float[]{0.175f, 0.3f, 0.4f, 0.125f};
    private static final int[] MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
    private final String itemName;

    public CoreArmor(EntityEquipmentSlot slot, String name) {
        super((IArmorMaterial)ArmorMaterial.DIAMOND, slot, GearHelper.getBuilder(null));
        this.itemName = name;
    }

    @Override
    public GearType getGearType() {
        switch (this.func_185083_B_()) {
            case HEAD: {
                return GearType.HELMET;
            }
            case CHEST: {
                return GearType.CHESTPLATE;
            }
            case LEGS: {
                return GearType.LEGGINGS;
            }
            case FEET: {
                return GearType.BOOTS;
            }
        }
        return GearType.ARMOR;
    }

    public double getArmorProtection(ItemStack stack) {
        if (GearHelper.isBroken(stack)) {
            return 0.0;
        }
        return ABSORPTION_RATIO_BY_SLOT[this.field_77881_a.func_188454_b()] * GearData.getStat(stack, CommonItemStats.ARMOR);
    }

    public double getArmorToughness(ItemStack stack) {
        if (GearHelper.isBroken(stack)) {
            return 0.0;
        }
        return GearData.getStat(stack, CommonItemStats.ARMOR_TOUGHNESS) / 4.0f;
    }

    private static double getGenericArmorProtection(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof CoreArmor) {
            return ((CoreArmor)item).getArmorProtection(stack);
        }
        if (item instanceof ItemArmor) {
            return ((ItemArmor)item).func_200881_e();
        }
        return 0.0;
    }

    private static int getPlayerTotalArmorValue(EntityLivingBase player) {
        float total = 0.0f;
        for (ItemStack armor : player.func_184193_aE()) {
            total = (float)((double)total + CoreArmor.getGenericArmorProtection(armor));
        }
        return Math.round(total);
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == this.field_77881_a) {
            UUID uuid = ARMOR_MODIFIERS[slot.func_188454_b()];
            multimap.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(uuid, "Armor modifier", this.getArmorProtection(stack), 0));
            multimap.put((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier(uuid, "Armor toughness", this.getArmorToughness(stack), 0));
        }
        return multimap;
    }

    public int getMaxDamage(ItemStack stack) {
        int maxDamageFactor = GearData.getStatInt(stack, CommonItemStats.ARMOR_DURABILITY);
        return MAX_DAMAGE_ARRAY[this.field_77881_a.func_188454_b()] * maxDamageFactor;
    }

    public void setDamage(ItemStack stack, int damage) {
        if (GearHelper.isUnbreakable(stack)) {
            return;
        }
        if (!((Boolean)Config.GENERAL.gearBreaksPermanently.get()).booleanValue()) {
            damage = MathHelper.func_76125_a((int)damage, (int)0, (int)this.getMaxDamage(stack));
        }
        super.setDamage(stack, damage);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return GearHelper.getIsRepairable(toRepair, repair);
    }

    public int getItemEnchantability(ItemStack stack) {
        return GearData.getStatInt(stack, CommonItemStats.ENCHANTABILITY);
    }

    public void onArmorTick(ItemStack stack, World world, EntityPlayer player) {
        GearHelper.inventoryTick(stack, world, (Entity)player, 0, true);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        GearHelper.fillItemGroup(this, group, items);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        int layer;
        int n = layer = slot == EntityEquipmentSlot.LEGS ? 2 : 1;
        if ("overlay".equals(type)) {
            return "silentgear:textures/models/armor/all_layer_" + layer + "_overlay.png";
        }
        PartData part = GearData.getPrimaryRenderPartFast(stack);
        if (part == null) {
            part = PartData.ofNullable(PartManager.tryGetFallback(PartType.MAIN));
        }
        IPartDisplay props = part.getPart().getDisplayProperties(part, stack, 0);
        return props.getTextureDomain() + ":textures/models/armor/" + props.getTextureSuffix() + "_layer_" + layer + (type != null ? "_" + type : "") + ".png";
    }

    public boolean func_77636_d(ItemStack stack) {
        return GearClientHelper.hasEffect(stack);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return GearHelper.getDisplayName(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        GearClientHelper.addInformation(stack, worldIn, tooltip, flagIn);
    }
}

