/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreRangedWeapon;
import net.silentchaos512.gear.api.stats.CommonItemStats;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.client.models.ToolModel;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public class CoreBow
extends ItemBow
implements ICoreRangedWeapon {
    private static final int MIN_DRAW_DELAY = 10;
    private static final int MAX_DRAW_DELAY = 100;

    public CoreBow() {
        super(GearHelper.getBuilder(null).func_200915_b(100));
        GearHelper.addModelTypeProperty(this);
    }

    @Override
    public GearType getGearType() {
        return GearType.BOW;
    }

    @Override
    public Optional<StatInstance> getBaseStatModifier(ItemStat stat) {
        if (stat == CommonItemStats.RANGED_DAMAGE) {
            return Optional.of(StatInstance.makeBaseMod(2.0f));
        }
        if (stat == CommonItemStats.RANGED_SPEED) {
            return Optional.of(StatInstance.makeBaseMod(1.0f));
        }
        if (stat == CommonItemStats.REPAIR_EFFICIENCY) {
            return Optional.of(StatInstance.makeBaseMod(1.0f));
        }
        return Optional.empty();
    }

    @Override
    public Optional<StatInstance> getStatModifier(ItemStat stat) {
        if (stat == CommonItemStats.ENCHANTABILITY) {
            return Optional.of(StatInstance.makeGearMod(-0.45f));
        }
        return Optional.empty();
    }

    @Override
    public float getDrawDelay(@Nonnull ItemStack stack) {
        return MathHelper.func_76131_a((float)ICoreRangedWeapon.super.getDrawDelay(stack), (float)10.0f, (float)100.0f);
    }

    public float getArrowVelocity(ItemStack stack, int charge) {
        float f = (float)charge / this.getDrawDelay(stack);
        return (f = (f * f + f * 2.0f) / 3.0f) > 1.0f ? 1.0f : f;
    }

    public float getArrowDamage(ItemStack stack) {
        return GearData.getStat(stack, CommonItemStats.RANGED_DAMAGE);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        if (player.field_70170_p.field_72995_K) {
            float pull = (float)(stack.func_77988_m() - player.func_184605_cv()) / this.getDrawDelay(stack);
            ToolModel.bowPull.put(GearData.getUUID(stack), Float.valueOf(pull));
        }
        super.onUsingTick(stack, player, count);
    }

    protected ItemStack func_185060_a(EntityPlayer player) {
        if (this.func_185058_h_(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.func_185058_h_(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.func_185058_h_(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        boolean hasAmmo = !this.func_185060_a(player).func_190926_b() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
        boolean isBroken = GearHelper.isBroken(stack);
        if (isBroken) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)stack, (World)world, (EntityPlayer)player, (EnumHand)hand, (boolean)hasAmmo);
        if (ret != null && ret.func_188397_a() == EnumActionResult.FAIL) {
            return ret;
        }
        if (!player.field_71075_bZ.field_75098_d && !hasAmmo) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (worldIn.field_72995_K) {
            ToolModel.bowPull.remove(GearData.getUUID(stack));
        }
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            boolean infiniteAmmo = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack ammo = this.func_185060_a(player);
            int i = this.func_77626_a(stack) - timeLeft;
            if (i < 0) {
                return;
            }
            if (!ammo.func_190926_b() || infiniteAmmo) {
                float velocity;
                if (ammo.func_190926_b()) {
                    ammo = new ItemStack((IItemProvider)Items.field_151032_g);
                }
                if ((double)(velocity = this.getArrowVelocity(stack, i)) >= 0.1) {
                    boolean flag1;
                    boolean bl = flag1 = player.field_71075_bZ.field_75098_d || ammo.func_77973_b() instanceof ItemArrow && ((ItemArrow)ammo.func_77973_b()).isInfinite(ammo, stack, player);
                    if (!worldIn.field_72995_K) {
                        int power;
                        ItemArrow itemarrow = (ItemArrow)(ammo.func_77973_b() instanceof ItemArrow ? ammo.func_77973_b() : Items.field_151032_g);
                        EntityArrow entityarrow = itemarrow.func_200887_a(worldIn, ammo, (EntityLivingBase)player);
                        entityarrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, velocity * 3.0f, 1.0f);
                        if (velocity == 1.0f) {
                            entityarrow.func_70243_d(true);
                        }
                        float powerBoost = (power = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0 ? (float)power * 0.5f + 0.5f : 0.0f;
                        float damageBoost = this.getArrowDamage(stack);
                        entityarrow.func_70239_b((double)(damageBoost + powerBoost));
                        int k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack);
                        if (k > 0) {
                            entityarrow.func_70240_a(k);
                        }
                        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                            entityarrow.func_70015_d(100);
                        }
                        stack.func_77972_a(1, (EntityLivingBase)player);
                        if (flag1) {
                            entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                        }
                        worldIn.func_72838_d((Entity)entityarrow);
                    }
                    worldIn.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + velocity * 0.5f);
                    if (!flag1) {
                        ammo.func_190918_g(1);
                        if (ammo.func_190916_E() == 0) {
                            player.field_71071_by.func_184437_d(ammo);
                        }
                    }
                }
            }
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        GearClientHelper.addInformation(stack, worldIn, tooltip, flagIn);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        return GearHelper.getAttributeModifiers(slot, stack);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return GearHelper.getIsRepairable(toRepair, repair);
    }

    public int getItemEnchantability(ItemStack stack) {
        return GearData.getStatInt(stack, CommonItemStats.ENCHANTABILITY);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return GearHelper.getDisplayName(stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return GearData.getStatInt(stack, CommonItemStats.DURABILITY);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return GearHelper.getRarity(stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        return GearClientHelper.hasEffect(stack);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        GearHelper.fillItemGroup(this, group, items);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        GearHelper.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return GearClientHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }
}

